/*
 * Decompiled with CFR 0.152.
 */
package model2_1.wellinterp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Set;
import model2_1.Audit;
import model2_1.Fault;
import model2_1.IGDIntervalZone;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Well;
import model2_1.WsWell;
import model2_1.wellinterp.InterpEdit;
import model2_1.wellinterp.InterpList;
import model2_1.wellinterp.InterpListObserver;
import model2_1.wellinterp.RefreshKey;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SBException;
import util.status.SbugsStatus;

public class FaultList
extends InterpList<Fault> {
    public FaultList(int interpID, InterpListObserver observer) {
        super(interpID, observer);
    }

    @Override
    public synchronized void load(Well well) throws SQLException {
        SBdb sbdb = super.initLoad(well);
        String sql = "SELECT samp_id,bnd,throw,label," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName(this.getTableName()) + " WHERE interp_id=" + this.interpID + " AND well_id=" + well.getWellID();
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int sampID = rs.getInt("samp_id");
                int bndInt = rs.getInt("bnd");
                IGDIntervalZone.Boundary bnd = IGDIntervalZone.Boundary.getBnd(bndInt);
                if (!bnd.isDisconformable()) {
                    bnd = IGDIntervalZone.Boundary.FAULT;
                }
                int faultThrow = rs.getInt("throw");
                String strg = rs.getString("label");
                Fault fault = new Fault(sbdb, well.getSample(sampID), bnd, faultThrow, strg, new Audit(rs));
                this.insert(fault);
            }
        }
    }

    public Fault add(Well well, Sample sample, IGDIntervalZone.Boundary bnd, double faultThrow, String label, SBdb sbdb) throws SQLException, InvalidFieldException {
        this.validate(null, sample, bnd);
        if (!bnd.isFault()) {
            faultThrow = 0.0;
        }
        Fault fault = new Fault(sbdb, sample, bnd, well.getWellID(), faultThrow, label, this.interpID);
        this.insert(fault);
        return fault;
    }

    @Override
    public InterpEdit<Fault> add() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Fault update(int wellID, Fault original, Sample sample, IGDIntervalZone.Boundary bnd, double faultThrow, String label, SBdb sbdb) throws SQLException, InvalidFieldException {
        this.validate(original, sample, bnd);
        if (!bnd.isFault()) {
            faultThrow = 0.0;
        }
        original.delete(wellID, this.interpID, null);
        Fault newFault = new Fault(sbdb, sample, bnd, faultThrow, label, new Audit(original.getAudit()));
        newFault.store(wellID, this.interpID);
        this.remove(original);
        this.insert(newFault);
        return newFault;
    }

    private void validate(Fault original, Sample sample, IGDIntervalZone.Boundary bnd) throws InvalidFieldException {
        for (Fault ft : this.getItems()) {
            if (original != null && ft == original || ft.getSample() != sample) continue;
            throw new InvalidFieldException("There is already a " + this.getItemDescriptor() + " at sample: " + sample.toString());
        }
        if (!bnd.isDisconformable()) {
            throw new InvalidFieldException("Boundary type must be disconformable");
        }
    }

    @Override
    public void insertStoredCopy(Fault itemToCopy, int wellID, SBdb sbdb) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    Fault copyToDatabase(Fault wsFault, int wellID, SBdb db) throws SQLException, SBException {
        Fault dbFault = Fault.copyToDatabase(wsFault, db);
        wsFault.setStatus(SbugsStatus.STORED);
        return dbFault;
    }

    @Override
    public String getItemDescriptor() {
        return "disconformity";
    }

    @Override
    String getAuditType() {
        return "FAULT";
    }

    @Override
    String getTableName() {
        return "FAULTS";
    }

    @Override
    String getRefreshQueryString(SBdb sbdb, int wellID, int interpID) {
        return "SELECT samp_id,updated FROM " + sbdb.DBTableName(this.getTableName()) + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
    }

    @Override
    RefreshKey<Fault> getRefreshKey(ResultSet rs) throws SQLException {
        final int sampID = rs.getInt("samp_id");
        return new RefreshKey<Fault>(){

            @Override
            public String getKey() {
                return "" + sampID;
            }

            @Override
            public boolean matches(Fault t) {
                return t.getSample().getSampID() == sampID;
            }

            @Override
            public int getSampID() {
                return sampID;
            }
        };
    }

    @Override
    String getRefreshKeyString(Fault t) {
        return "" + t.getSample().getSampID();
    }

    @Override
    Fault load(RefreshKey<Fault> refreshKey, Fault t, SBdb sbdb, Well well, int interpID) throws SQLException, SBException {
        return Fault.load(sbdb, well, interpID, refreshKey.getSampID(), t);
    }

    @Override
    Fault copyToWorkspace(Fault dbFault, SBdb db, WsWell wsWell) throws SQLException, SBException {
        Sample wsSample = wsWell.getSample(dbFault.getSample().getSampID());
        Audit wsAudit = new Audit(dbFault.getAudit());
        wsAudit.fillWorkspace(wsWell.getLink().getDataModel(), db);
        return new Fault(db, wsSample, dbFault.getBnd(), dbFault.getThrow(), dbFault.getLabel(), wsAudit);
    }

    @Override
    int getDataType(Fault t) {
        return 27;
    }

    @Override
    String getXmlElementFilterName() {
        return "Disconformity";
    }

    @Override
    Fault parseXmlItem(SBdb sbdb, WsWell well, Element xml, Set<Integer> dataTypes) throws SQLException, SBException, ParseException {
        return new Fault(sbdb, well, xml);
    }
}

