/*
 * Decompiled with CFR 0.152.
 */
package model2_1.wellinterp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Set;
import model2_1.Audit;
import model2_1.IGDScheme;
import model2_1.SBdb;
import model2_1.SQPick;
import model2_1.Surface;
import model2_1.Well;
import model2_1.WsWell;
import model2_1.wellinterp.InterpEdit;
import model2_1.wellinterp.InterpList;
import model2_1.wellinterp.InterpListObserver;
import model2_1.wellinterp.RefreshKey;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SBException;

public class SQPickList
extends InterpList<SQPick> {
    public SQPickList(int interpID, InterpListObserver observer) {
        super(interpID, observer);
    }

    @Override
    public void load(Well well) throws SQLException {
        SBdb sbdb = super.initLoad(well);
        Object sql = "SELECT samp_id,sch_id,p.surface_id,inf,bnd,qualifier,observed," + Audit.sqlFieldString("p");
        sql = (String)sql + " FROM " + sbdb.DBTableName(this.getTableName()) + " p, " + sbdb.DBTableName("SURFACE") + " s  WHERE interp_id=" + this.interpID + " AND well_id=" + well.getWellID() + " AND s.surface_id=p.surface_id";
        sql = sbdb.modQuery((String)sql);
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery((String)sql);
            while (rs.next()) {
                String obsString;
                boolean observed;
                int sampID = rs.getInt("samp_id");
                int schID = rs.getInt("sch_id");
                IGDScheme scheme = sbdb.getIGDScheme(schID);
                int surfaceID = rs.getInt("surface_id");
                Surface surface = scheme.getSurface(surfaceID);
                String inf = rs.getString("inf");
                int bnd = rs.getInt("bnd");
                String strg = rs.getString("qualifier");
                boolean questionable = false;
                if (strg != null && strg.length() > 0 && strg.equals("?")) {
                    questionable = true;
                }
                boolean bl = observed = (obsString = rs.getString("observed")) == null || !obsString.equals("N");
                if (surface != null) {
                    SQPick pick = new SQPick.Builder(sbdb, surface, well.getSample(sampID), bnd).informalName(inf).questionable(questionable).observed(observed).audit(new Audit(rs, "p")).build();
                    this.insert(pick);
                    continue;
                }
                System.out.println("Unable to load pick with null surface, sample: " + sampID + " surface: " + surfaceID);
            }
        }
    }

    @Override
    public InterpEdit<SQPick> add() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SQPick add(Well well, SQPick.Builder builder, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        this.checkBuilderSample(null, builder);
        SQPick pick = sbdb != null && sbdb.isConnected() ? builder.build(well.getWellID(), this.interpID) : builder.build();
        this.insert(pick);
        return pick;
    }

    public InterpEdit<SQPick> update(SQPick original, int wellID, SQPick.Builder builder, SBdb sbdb) throws InvalidFieldException, SQLException {
        this.checkBuilderSample(original, builder);
        SQPickEdit edit = new SQPickEdit(wellID, original, builder, sbdb);
        edit.doEdit();
        return edit;
    }

    private void checkBuilderSample(SQPick original, SQPick.Builder builder) throws InvalidFieldException {
        for (SQPick pick : this.getItems()) {
            if (pick == original || pick.getSample() != builder.getSample()) continue;
            if (builder.isObserved() && pick.isObserved()) {
                throw new InvalidFieldException("There is already a pick at sample '" + builder.getSample().toString() + "'");
            }
            if (!builder.getSurface().equals(pick.getSurface())) continue;
            throw new InvalidFieldException("This surface is already picked at this sample");
        }
    }

    @Override
    public void insertStoredCopy(SQPick pickToCopy, int wellID, SBdb sbdb) throws SQLException, SBException, InvalidFieldException {
        SQPick.Builder copyBuilder = SQPick.Builder.copyOf(pickToCopy);
        this.checkBuilderSample(null, copyBuilder);
        this.insert(copyBuilder.build(wellID, this.interpID));
    }

    @Override
    SQPick copyToDatabase(SQPick wsPick, int wellID, SBdb db) throws SQLException, SBException {
        if (wsPick.getSurface() == null || wsPick.getSurface().getLink() == null) {
            throw new SBException("Attempt to store sequence pick with no matched surface: " + wsPick);
        }
        SQPick dbPick = SQPick.copyToDatabase(db, wsPick);
        dbPick.store(wellID, this.interpID);
        return dbPick;
    }

    @Override
    public String getItemDescriptor() {
        return "sequence pick";
    }

    @Override
    String getAuditType() {
        return "SQPICK";
    }

    @Override
    String getTableName() {
        return "SQPICK";
    }

    @Override
    String getRefreshQueryString(SBdb sbdb, int wellID, int interpID) {
        return "SELECT samp_id,surface_id,updated FROM " + sbdb.DBTableName("SQPICK") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
    }

    @Override
    RefreshKey<SQPick> getRefreshKey(ResultSet rs) throws SQLException {
        final int sampID = rs.getInt("samp_id");
        final int surfaceID = rs.getInt("surface_id");
        return new RefreshKey<SQPick>(){

            @Override
            public String getKey() {
                return sampID + "|" + surfaceID;
            }

            @Override
            public boolean matches(SQPick t) {
                return t.getSampID() == sampID && t.getSurfaceID() == surfaceID;
            }

            @Override
            public int getSampID() {
                return sampID;
            }

            @Override
            public Integer getDictID() {
                return surfaceID;
            }
        };
    }

    @Override
    String getRefreshKeyString(SQPick t) {
        return t.getSampID() + "|" + t.getSurfaceID();
    }

    @Override
    SQPick load(RefreshKey<SQPick> refreshKey, SQPick t, SBdb sbdb, Well well, int interpID) throws SQLException, SBException {
        return SQPick.load(sbdb, well, interpID, refreshKey.getSampID(), refreshKey.getDictID(), t);
    }

    @Override
    SQPick copyToWorkspace(SQPick dbPick, SBdb db, WsWell wsWell) throws SQLException, SBException {
        return new SQPick(db, dbPick, wsWell);
    }

    @Override
    int getDataType(SQPick t) {
        return 14;
    }

    @Override
    String getXmlElementFilterName() {
        return "SequencePick";
    }

    @Override
    SQPick parseXmlItem(SBdb sbdb, WsWell well, Element xml, Set<Integer> dataTypes) throws SQLException, SBException, ParseException {
        return new SQPick(sbdb, well, xml);
    }

    private static String initSQPickEditPresentationName(SQPick originalPick, SQPick.Builder builder) {
        String s = originalPick != null && builder != null ? "update sequence pick" : (originalPick != null ? "delete sequence pick" : "new sequence pick");
        return s;
    }

    private class SQPickEdit
    extends InterpEdit<SQPick> {
        final SQPick originalPick;
        final int wellID;
        SQPick.Builder builder;
        SQPick newPick;
        private final SBdb sbdb;
        private SQPick notifier;

        private SQPickEdit(int wellID, SQPick originalPick, SQPick.Builder builder, SBdb sbdb) {
            super(SQPickList.initSQPickEditPresentationName(originalPick, builder));
            this.originalPick = originalPick;
            this.builder = builder;
            this.wellID = wellID;
            this.sbdb = sbdb;
        }

        public void undo() {
            try {
                if (this.newPick != null) {
                    this.deleteActionDB(this.newPick);
                }
                if (this.originalPick != null) {
                    this.insertActionDB(this.originalPick);
                }
                if (this.newPick != null) {
                    this.deleteActionModel(this.newPick);
                }
                if (this.originalPick != null) {
                    this.insertActionModel(this.originalPick);
                }
            }
            catch (SQLException e) {
                this.sbdb.doRollback();
                e.printStackTrace();
                throw new RuntimeException("Error undoing sequence pick edit", e);
            }
            this.notifier = this.originalPick != null ? this.originalPick : this.newPick;
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalPick != null) {
                    this.deleteActionDB(this.originalPick);
                }
                if (!(built = this.buildNewPick()) && this.newPick != null) {
                    this.insertActionDB(this.newPick);
                }
                if (this.originalPick != null) {
                    this.deleteActionModel(this.originalPick);
                }
                if (this.newPick != null) {
                    this.insertActionModel(this.newPick);
                }
            }
            catch (SQLException e) {
                this.sbdb.doRollback();
                e.printStackTrace();
                throw new RuntimeException("Error redoing sequence pick edit", e);
            }
            this.notifier = this.newPick != null ? this.newPick : this.originalPick;
            super.redo();
        }

        private boolean buildNewPick() throws SQLException {
            if (this.builder == null) {
                return false;
            }
            this.newPick = this.builder.build(this.wellID, SQPickList.this.interpID);
            this.builder = null;
            return true;
        }

        private void insertActionDB(SQPick pick) throws SQLException {
            pick.store(this.wellID, SQPickList.this.interpID);
        }

        private void insertActionModel(SQPick pick) {
            SQPickList.this.insert(pick);
        }

        private void deleteActionDB(SQPick pick) throws SQLException {
            pick.delete(this.wellID, SQPickList.this.interpID, null);
        }

        private void deleteActionModel(SQPick pick) {
            SQPickList.this.remove(pick);
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public SQPick getItem() {
            return this.newPick;
        }

        @Override
        public SQPick getNotifier() {
            return this.notifier;
        }

        @Override
        public void doCommitAndNotify() throws SQLException {
            if (this.notifier == null) {
                return;
            }
            this.sbdb.commit();
            SQPickList.this.notifyObserver(this.notifier);
        }
    }
}

