/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.command.ddl;

import org.h2.mod.command.ddl.SchemaCommand;
import org.h2.mod.constraint.Constraint;
import org.h2.mod.engine.Session;
import org.h2.mod.message.DbException;
import org.h2.mod.schema.Schema;

public class AlterTableRenameConstraint
extends SchemaCommand {
    private String constraintName;
    private String newConstraintName;

    public AlterTableRenameConstraint(Session session, Schema schema) {
        super(session, schema);
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public void setNewConstraintName(String string) {
        this.newConstraintName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Constraint constraint = this.getSchema().findConstraint(this.session, this.constraintName);
        if (constraint == null) {
            throw DbException.get(90057, this.constraintName);
        }
        if (this.getSchema().findConstraint(this.session, this.newConstraintName) != null || this.newConstraintName.equals(this.constraintName)) {
            throw DbException.get(90045, this.newConstraintName);
        }
        this.session.getUser().checkRight(constraint.getTable(), 15);
        this.session.getUser().checkRight(constraint.getRefTable(), 15);
        this.session.getDatabase().renameSchemaObject(this.session, constraint, this.newConstraintName);
        return 0;
    }

    @Override
    public int getType() {
        return 85;
    }
}

