/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.command.ddl;

import org.h2.mod.command.ddl.SchemaCommand;
import org.h2.mod.engine.Database;
import org.h2.mod.engine.FunctionAlias;
import org.h2.mod.engine.Session;
import org.h2.mod.message.DbException;
import org.h2.mod.schema.Schema;

public class DropFunctionAlias
extends SchemaCommand {
    private String aliasName;
    private boolean ifExists;

    public DropFunctionAlias(Session session, Schema schema) {
        super(session, schema);
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        FunctionAlias functionAlias = this.getSchema().findFunction(this.aliasName);
        if (functionAlias == null) {
            if (!this.ifExists) {
                throw DbException.get(90077, this.aliasName);
            }
        } else {
            database.removeSchemaObject(this.session, functionAlias);
        }
        return 0;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    @Override
    public int getType() {
        return 39;
    }
}

