/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.command.dml;

import org.h2.mod.command.Prepared;
import org.h2.mod.engine.Session;
import org.h2.mod.expression.Expression;
import org.h2.mod.expression.ExpressionVisitor;
import org.h2.mod.result.LocalResult;
import org.h2.mod.result.ResultInterface;
import org.h2.mod.value.Value;

public class Call
extends Prepared {
    private boolean isResultSet;
    private Expression expression;
    private Expression[] expressions;

    public Call(Session session) {
        super(session);
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult;
        if (this.isResultSet) {
            Expression[] expressionArray = this.expression.getExpressionColumns(this.session);
            localResult = this.session.getDatabase().getResultFactory().create(this.session, expressionArray, expressionArray.length);
        } else {
            localResult = this.session.getDatabase().getResultFactory().create(this.session, this.expressions, 1);
        }
        localResult.done();
        return localResult;
    }

    @Override
    public int update() {
        Value value = this.expression.getValue(this.session);
        int n = value.getValueType();
        switch (n) {
            case 18: {
                return super.update();
            }
            case -1: 
            case 0: {
                return 0;
            }
        }
        return value.getInt();
    }

    @Override
    public ResultInterface query(int n) {
        this.setCurrentRowNumber(1L);
        Value value = this.expression.getValue(this.session);
        if (this.isResultSet) {
            return value.getResult();
        }
        LocalResult localResult = this.session.getDatabase().getResultFactory().create(this.session, this.expressions, 1);
        Value[] valueArray = new Value[]{value};
        localResult.addRow(valueArray);
        localResult.done();
        return localResult;
    }

    @Override
    public void prepare() {
        this.expression = this.expression.optimize(this.session);
        this.expressions = new Expression[]{this.expression};
        boolean bl = this.isResultSet = this.expression.getType().getValueType() == 18;
        if (this.isResultSet) {
            this.prepareAlways = true;
        }
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.expression.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    @Override
    public int getType() {
        return 57;
    }

    @Override
    public boolean isCacheable() {
        return !this.isResultSet;
    }
}

