/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.expression;

import java.util.ArrayList;
import org.h2.mod.command.dml.Query;
import org.h2.mod.engine.Session;
import org.h2.mod.expression.Expression;
import org.h2.mod.expression.ExpressionList;
import org.h2.mod.expression.ExpressionVisitor;
import org.h2.mod.message.DbException;
import org.h2.mod.result.ResultInterface;
import org.h2.mod.table.ColumnResolver;
import org.h2.mod.table.TableFilter;
import org.h2.mod.value.TypeInfo;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueNull;
import org.h2.mod.value.ValueRow;

public class Subquery
extends Expression {
    private final Query query;
    private Expression expression;

    public Subquery(Query query) {
        this.query = query;
    }

    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        try (ResultInterface resultInterface = this.query.query(2);){
            Value[] valueArray;
            Value value;
            if (!resultInterface.next()) {
                value = ValueNull.INSTANCE;
            } else {
                valueArray = resultInterface.currentRow();
                value = resultInterface.getVisibleColumnCount() == 1 ? valueArray[0] : ValueRow.get(valueArray);
                if (resultInterface.hasNext()) {
                    throw DbException.get(90053);
                }
            }
            valueArray = value;
            return valueArray;
        }
    }

    @Override
    public TypeInfo getType() {
        return this.getExpression().getType();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.query.mapColumns(columnResolver, n + 1);
    }

    @Override
    public Expression optimize(Session session) {
        session.optimizeQueryExpression(this.query);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.query.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append('(').append(this.query.getPlanSQL(bl)).append(')');
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.query.updateAggregate(session, n);
    }

    private Expression getExpression() {
        if (this.expression == null) {
            ArrayList<Expression> arrayList = this.query.getExpressions();
            int n = this.query.getColumnCount();
            if (n == 1) {
                this.expression = arrayList.get(0);
            } else {
                Expression[] expressionArray = new Expression[n];
                for (int i = 0; i < n; ++i) {
                    expressionArray[i] = arrayList.get(i);
                }
                this.expression = new ExpressionList(expressionArray, false);
            }
        }
        return this.expression;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.query.isEverything(expressionVisitor);
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return this.getExpression().getExpressionColumns(session);
    }
}

