/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.expression;

import org.h2.mod.command.Parser;
import org.h2.mod.engine.Session;
import org.h2.mod.expression.Expression;
import org.h2.mod.expression.ExpressionVisitor;
import org.h2.mod.message.DbException;
import org.h2.mod.table.ColumnResolver;
import org.h2.mod.table.TableFilter;
import org.h2.mod.value.TypeInfo;
import org.h2.mod.value.Value;

public class Variable
extends Expression {
    private final String name;
    private Value lastValue;

    public Variable(Session session, String string) {
        this.name = string;
        this.lastValue = session.getVariable(string);
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('@');
        return Parser.quoteIdentifier(stringBuilder, this.name, bl);
    }

    @Override
    public TypeInfo getType() {
        return this.lastValue.getType();
    }

    @Override
    public Value getValue(Session session) {
        this.lastValue = session.getVariable(this.name);
        return this.lastValue;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public void updateAggregate(Session session, int n) {
    }

    public String getName() {
        return this.name;
    }
}

