/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.util;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int ALL = 3;
    public static final int ARRAY = 4;
    public static final int CASE = 5;
    public static final int CHECK = 6;
    public static final int CONSTRAINT = 7;
    public static final int CROSS = 8;
    public static final int CURRENT_DATE = 9;
    public static final int CURRENT_TIME = 10;
    public static final int CURRENT_TIMESTAMP = 11;
    public static final int CURRENT_USER = 12;
    public static final int DISTINCT = 13;
    public static final int EXCEPT = 14;
    public static final int EXISTS = 15;
    public static final int FALSE = 16;
    public static final int FETCH = 17;
    public static final int FOR = 18;
    public static final int FOREIGN = 19;
    public static final int FROM = 20;
    public static final int FULL = 21;
    public static final int GROUP = 22;
    public static final int HAVING = 23;
    public static final int IF = 24;
    public static final int INNER = 25;
    public static final int INTERSECT = 26;
    public static final int INTERSECTS = 27;
    public static final int INTERVAL = 28;
    public static final int IS = 29;
    public static final int JOIN = 30;
    public static final int LIKE = 31;
    public static final int LIMIT = 32;
    public static final int LOCALTIME = 33;
    public static final int LOCALTIMESTAMP = 34;
    public static final int MINUS = 35;
    public static final int NATURAL = 36;
    public static final int NOT = 37;
    public static final int NULL = 38;
    public static final int OFFSET = 39;
    public static final int ON = 40;
    public static final int ORDER = 41;
    public static final int PRIMARY = 42;
    public static final int QUALIFY = 43;
    public static final int ROW = 44;
    public static final int _ROWID_ = 45;
    public static final int ROWNUM = 46;
    public static final int SELECT = 47;
    public static final int TABLE = 48;
    public static final int TRUE = 49;
    public static final int UNION = 50;
    public static final int UNIQUE = 51;
    public static final int VALUES = 52;
    public static final int WHERE = 53;
    public static final int WINDOW = 54;
    public static final int WITH = 55;
    private static final int UPPER_OR_OTHER_LETTER = 50;
    private static final int UPPER_OR_OTHER_LETTER_OR_DIGIT = 562;
    private static final int LOWER_OR_OTHER_LETTER = 52;
    private static final int LOWER_OR_OTHER_LETTER_OR_DIGIT = 564;
    private static final int LETTER = 62;
    private static final int LETTER_OR_DIGIT = 574;

    private ParserUtil() {
    }

    public static boolean isKeyword(String string, boolean bl) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        return ParserUtil.getSaveTokenType(string, bl, 0, n, false) != 2;
    }

    public static boolean isSimpleIdentifier(String string, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return false;
        }
        if (bl) {
            if (bl2) {
                throw new IllegalArgumentException("databaseToUpper && databaseToLower");
            }
            n2 = 50;
            n = 562;
        } else if (bl2) {
            n2 = 52;
            n = 564;
        } else {
            n2 = 62;
            n = 574;
        }
        char c = string.charAt(0);
        if ((n2 >>> Character.getType(c) & 1) == 0 && c != '_') {
            return false;
        }
        for (int i = 1; i < n3; ++i) {
            c = string.charAt(i);
            if ((n >>> Character.getType(c) & 1) != 0 || c == '_') continue;
            return false;
        }
        return ParserUtil.getSaveTokenType(string, !bl, 0, n3, true) == 2;
    }

    public static int getSaveTokenType(String string, boolean bl, int n, int n2, boolean bl2) {
        char c = string.charAt(n);
        if (bl) {
            c = (char)(c & 0xFFDF);
        }
        switch (c) {
            case 'A': {
                if (ParserUtil.eq("ALL", string, bl, n, n2)) {
                    return 3;
                }
                if (ParserUtil.eq("ARRAY", string, bl, n, n2)) {
                    return 4;
                }
                if (bl2 && (ParserUtil.eq("AND", string, bl, n, n2) || ParserUtil.eq("AS", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'B': {
                if (bl2 && (ParserUtil.eq("BETWEEN", string, bl, n, n2) || ParserUtil.eq("BOTH", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'C': {
                if (ParserUtil.eq("CASE", string, bl, n, n2)) {
                    return 5;
                }
                if (ParserUtil.eq("CHECK", string, bl, n, n2)) {
                    return 6;
                }
                if (ParserUtil.eq("CONSTRAINT", string, bl, n, n2)) {
                    return 7;
                }
                if (ParserUtil.eq("CROSS", string, bl, n, n2)) {
                    return 8;
                }
                if (ParserUtil.eq("CURRENT_DATE", string, bl, n, n2)) {
                    return 9;
                }
                if (ParserUtil.eq("CURRENT_TIME", string, bl, n, n2)) {
                    return 10;
                }
                if (ParserUtil.eq("CURRENT_TIMESTAMP", string, bl, n, n2)) {
                    return 11;
                }
                if (ParserUtil.eq("CURRENT_USER", string, bl, n, n2)) {
                    return 12;
                }
                return 2;
            }
            case 'D': {
                if (ParserUtil.eq("DISTINCT", string, bl, n, n2)) {
                    return 13;
                }
                return 2;
            }
            case 'E': {
                if (ParserUtil.eq("EXCEPT", string, bl, n, n2)) {
                    return 14;
                }
                if (ParserUtil.eq("EXISTS", string, bl, n, n2)) {
                    return 15;
                }
                return 2;
            }
            case 'F': {
                if (ParserUtil.eq("FETCH", string, bl, n, n2)) {
                    return 17;
                }
                if (ParserUtil.eq("FROM", string, bl, n, n2)) {
                    return 20;
                }
                if (ParserUtil.eq("FOR", string, bl, n, n2)) {
                    return 18;
                }
                if (ParserUtil.eq("FOREIGN", string, bl, n, n2)) {
                    return 19;
                }
                if (ParserUtil.eq("FULL", string, bl, n, n2)) {
                    return 21;
                }
                if (ParserUtil.eq("FALSE", string, bl, n, n2)) {
                    return 16;
                }
                if (bl2 && ParserUtil.eq("FILTER", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'G': {
                if (ParserUtil.eq("GROUP", string, bl, n, n2)) {
                    return 22;
                }
                if (bl2 && ParserUtil.eq("GROUPS", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'H': {
                if (ParserUtil.eq("HAVING", string, bl, n, n2)) {
                    return 23;
                }
                return 2;
            }
            case 'I': {
                if (ParserUtil.eq("IF", string, bl, n, n2)) {
                    return 24;
                }
                if (ParserUtil.eq("INNER", string, bl, n, n2)) {
                    return 25;
                }
                if (ParserUtil.eq("INTERSECT", string, bl, n, n2)) {
                    return 26;
                }
                if (ParserUtil.eq("INTERSECTS", string, bl, n, n2)) {
                    return 27;
                }
                if (ParserUtil.eq("INTERVAL", string, bl, n, n2)) {
                    return 28;
                }
                if (ParserUtil.eq("IS", string, bl, n, n2)) {
                    return 29;
                }
                if (bl2 && (ParserUtil.eq("ILIKE", string, bl, n, n2) || ParserUtil.eq("IN", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'J': {
                if (ParserUtil.eq("JOIN", string, bl, n, n2)) {
                    return 30;
                }
                return 2;
            }
            case 'L': {
                if (ParserUtil.eq("LIMIT", string, bl, n, n2)) {
                    return 32;
                }
                if (ParserUtil.eq("LIKE", string, bl, n, n2)) {
                    return 31;
                }
                if (ParserUtil.eq("LOCALTIME", string, bl, n, n2)) {
                    return 33;
                }
                if (ParserUtil.eq("LOCALTIMESTAMP", string, bl, n, n2)) {
                    return 34;
                }
                if (bl2 && (ParserUtil.eq("LEADING", string, bl, n, n2) || ParserUtil.eq("LEFT", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'M': {
                if (ParserUtil.eq("MINUS", string, bl, n, n2)) {
                    return 35;
                }
                return 2;
            }
            case 'N': {
                if (ParserUtil.eq("NOT", string, bl, n, n2)) {
                    return 37;
                }
                if (ParserUtil.eq("NATURAL", string, bl, n, n2)) {
                    return 36;
                }
                if (ParserUtil.eq("NULL", string, bl, n, n2)) {
                    return 38;
                }
                return 2;
            }
            case 'O': {
                if (ParserUtil.eq("OFFSET", string, bl, n, n2)) {
                    return 39;
                }
                if (ParserUtil.eq("ON", string, bl, n, n2)) {
                    return 40;
                }
                if (ParserUtil.eq("ORDER", string, bl, n, n2)) {
                    return 41;
                }
                if (bl2 && (ParserUtil.eq("OR", string, bl, n, n2) || ParserUtil.eq("OVER", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'P': {
                if (ParserUtil.eq("PRIMARY", string, bl, n, n2)) {
                    return 42;
                }
                if (bl2 && ParserUtil.eq("PARTITION", string, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'Q': {
                if (ParserUtil.eq("QUALIFY", string, bl, n, n2)) {
                    return 43;
                }
                return 2;
            }
            case 'R': {
                if (ParserUtil.eq("ROW", string, bl, n, n2)) {
                    return 44;
                }
                if (ParserUtil.eq("ROWNUM", string, bl, n, n2)) {
                    return 46;
                }
                if (bl2 && (ParserUtil.eq("RANGE", string, bl, n, n2) || ParserUtil.eq("REGEXP", string, bl, n, n2) || ParserUtil.eq("ROWS", string, bl, n, n2) || ParserUtil.eq("RIGHT", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'S': {
                if (ParserUtil.eq("SELECT", string, bl, n, n2)) {
                    return 47;
                }
                if (bl2 && (ParserUtil.eq("SYSDATE", string, bl, n, n2) || ParserUtil.eq("SYSTIME", string, bl, n, n2) || ParserUtil.eq("SYSTIMESTAMP", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'T': {
                if (ParserUtil.eq("TABLE", string, bl, n, n2)) {
                    return 48;
                }
                if (ParserUtil.eq("TRUE", string, bl, n, n2)) {
                    return 49;
                }
                if (bl2 && (ParserUtil.eq("TODAY", string, bl, n, n2) || ParserUtil.eq("TOP", string, bl, n, n2) || ParserUtil.eq("TRAILING", string, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'U': {
                if (ParserUtil.eq("UNIQUE", string, bl, n, n2)) {
                    return 51;
                }
                if (ParserUtil.eq("UNION", string, bl, n, n2)) {
                    return 50;
                }
                return 2;
            }
            case 'V': {
                if (ParserUtil.eq("VALUES", string, bl, n, n2)) {
                    return 52;
                }
                return 2;
            }
            case 'W': {
                if (ParserUtil.eq("WHERE", string, bl, n, n2)) {
                    return 53;
                }
                if (ParserUtil.eq("WINDOW", string, bl, n, n2)) {
                    return 54;
                }
                if (ParserUtil.eq("WITH", string, bl, n, n2)) {
                    return 55;
                }
                return 2;
            }
            case '_': {
                if (n2 - n != 7 || !"_ROWID_".regionMatches(bl, 0, string, n, 7)) break;
                return 45;
            }
        }
        return 2;
    }

    private static boolean eq(String string, String string2, boolean bl, int n, int n2) {
        int n3 = string.length();
        return n2 - n == n3 && string.regionMatches(bl, 1, string2, n + 1, n3 - 1);
    }
}

