/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.svg;

import java.awt.RenderingHints;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.ows.URLCheckers;
import org.geotools.renderer.style.svg.RenderableSVG;
import org.geotools.util.Converters;
import org.geotools.util.SoftValueHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenderableSVGCache {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("param\\((.+)\\).*");
    static Map<String, RenderableSVG> glyphCache = Collections.synchronizedMap(new SoftValueHashMap());
    static final Set<String> formats = new HashSet<String>();

    public RenderableSVGCache() {
        this(null);
    }

    public RenderableSVGCache(Map<RenderingHints.Key, Object> hints) {
    }

    public RenderableSVG getRenderableSVG(Feature feature, Expression url, String format) throws Exception {
        if (format == null || !formats.contains(format.toLowerCase())) {
            return null;
        }
        String svgfile = (String)url.evaluate((Object)feature, String.class);
        if (svgfile == null) {
            throw new IllegalArgumentException("The specified expression could not be turned into an URL");
        }
        if (Converters.convert((Object)svgfile, URL.class) == null) {
            throw new IllegalArgumentException("Invalid URL: " + svgfile);
        }
        URLCheckers.confirm(svgfile);
        RenderableSVG svg = glyphCache.get(svgfile);
        if (svg == null) {
            Document doc;
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            int queryIdx = svgfile.indexOf("?");
            if (svgfile.startsWith("file:/") && queryIdx > 0) {
                String localPath = svgfile.substring(0, queryIdx);
                doc = f.createDocument(localPath);
            } else {
                doc = f.createDocument(svgfile);
            }
            Map<String, String> parameters = this.getParametersFromUrl(svgfile);
            if (!parameters.isEmpty() || this.hasParameters(doc.getDocumentElement())) {
                this.replaceParameters(doc.getDocumentElement(), parameters);
            }
            svg = new RenderableSVG(doc);
            glyphCache.put(svgfile, svg);
        }
        return svg;
    }

    Map<String, String> getParametersFromUrl(String url) {
        int idx = url.indexOf("?");
        if (idx == -1 || idx == url.length() - 1) {
            return Collections.emptyMap();
        }
        String query = url.substring(idx + 1);
        return Arrays.stream(query.split("&")).map(this::splitQueryParameter).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue(), (v1, v2) -> v2));
    }

    AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String parameter) {
        int idx = parameter.indexOf("=");
        String key = idx > 0 ? parameter.substring(0, idx) : parameter;
        try {
            String value = null;
            if (idx > 0 && parameter.length() > idx + 1) {
                String encodedValue = parameter.substring(idx + 1);
                value = URLDecoder.decode(encodedValue, "UTF-8");
            }
            return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasParameters(Element root) {
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String nv = attribute.getNodeValue();
            if (nv == null || !nv.contains("param(")) continue;
            return true;
        }
        if (root.hasChildNodes()) {
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node n = childNodes.item(i);
                if (n == null || !(n instanceof Element) || !this.hasParameters((Element)n)) continue;
                return true;
            }
        }
        return true;
    }

    private void replaceParameters(Element root, Map<String, String> parameters) {
        int i;
        if (root.hasChildNodes()) {
            NodeList childNodes = root.getChildNodes();
            for (i = 0; i < childNodes.getLength(); ++i) {
                Node n = childNodes.item(i);
                if (n == null || !(n instanceof Element)) continue;
                this.replaceParameters((Element)n, parameters);
            }
        }
        NamedNodeMap attributes = root.getAttributes();
        for (i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if ("style".equalsIgnoreCase(attribute.getNodeName())) {
                String[] keyValues = attribute.getNodeValue().split("\\s*;\\s*");
                StringBuilder newAttribute = new StringBuilder();
                for (String keyValue : keyValues) {
                    String[] kv = keyValue.split("\\s*:\\s*");
                    if (kv.length < 2) continue;
                    String key = kv[0];
                    String value = this.replaceValue(kv[1], parameters);
                    newAttribute.append(key).append(":").append(value).append(";");
                }
                attribute.setNodeValue(newAttribute.toString());
                continue;
            }
            String value = this.replaceValue(attribute.getNodeValue(), parameters);
            attribute.setNodeValue(value);
        }
    }

    private String replaceValue(String value, Map<String, String> parameters) {
        Matcher m = PARAMETER_PATTERN.matcher(value);
        if (m.matches()) {
            String key = m.group(1);
            String newValue = parameters.get(key);
            value = newValue != null ? newValue : (key.contains("width") ? "0" : (key.contains("opacity") || key.contains("alpha") ? "1" : "#000000"));
        }
        return value;
    }

    public static void resetCache() {
        glyphCache.clear();
    }

    static {
        formats.add("image/svg");
        formats.add("image/svg-xml");
        formats.add("image/svg+xml");
    }
}

