/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.svg;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.ows.URLCheckers;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.GraphicCache;
import org.geotools.renderer.style.svg.RenderableSVG;
import org.geotools.renderer.style.svg.RenderableSVGCache;
import org.geotools.util.CanonicalSet;
import org.geotools.util.factory.Factory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SVGGraphicFactory
implements Factory,
ExternalGraphicFactory,
GraphicCache {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("param\\((.+)\\).*");
    RenderableSVGCache glyphCache;
    static final Set<String> formats = new HashSet<String>();
    static final CanonicalSet<String> CANONICAL_PATHS = CanonicalSet.newInstance(String.class);
    private final Map<RenderingHints.Key, Object> implementationHints = new HashMap<RenderingHints.Key, Object>();

    public SVGGraphicFactory() {
        this(null);
    }

    public SVGGraphicFactory(Map<RenderingHints.Key, Object> hints) {
        this.glyphCache = new RenderableSVGCache(hints);
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.implementationHints;
    }

    @Override
    public Icon getIcon(Feature feature, Expression url, String format, int size) throws Exception {
        if (format == null || !formats.contains(format.toLowerCase())) {
            return null;
        }
        RenderableSVG svg = this.glyphCache.getRenderableSVG(feature, url, format);
        return new SVGIcon(svg, size);
    }

    protected RenderableSVG toRenderableSVG(String svgfile, URL svgUrl) throws SAXException, IOException {
        int idx;
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        String svgUri = svgfile;
        if ("file".equals(svgUrl.getProtocol()) && svgUrl.getQuery() != null && (idx = svgfile.indexOf(63)) > -1) {
            svgUri = svgfile.substring(0, idx);
        }
        URLCheckers.confirm(svgUri);
        Document doc = f.createDocument(svgUri);
        Map<String, String> parameters = this.getParametersFromUrl(svgfile);
        if (!parameters.isEmpty() || this.hasParameters(doc.getDocumentElement())) {
            this.replaceParameters(doc.getDocumentElement(), parameters);
        }
        RenderableSVG svg = new RenderableSVG(doc);
        return svg;
    }

    Map<String, String> getParametersFromUrl(String url) {
        int idx = url.indexOf("?");
        if (idx == -1 || idx == url.length() - 1) {
            return Collections.emptyMap();
        }
        String query = url.substring(idx + 1);
        return Arrays.stream(query.split("&")).map(this::splitQueryParameter).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue(), (v1, v2) -> v2));
    }

    AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String parameter) {
        int idx = parameter.indexOf("=");
        String key = idx > 0 ? parameter.substring(0, idx) : parameter;
        try {
            String value = null;
            if (idx > 0 && parameter.length() > idx + 1) {
                String encodedValue = parameter.substring(idx + 1);
                value = URLDecoder.decode(encodedValue, "UTF-8");
            }
            return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasParameters(Element root) {
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String nv = attribute.getNodeValue();
            if (nv == null || !nv.contains("param(")) continue;
            return true;
        }
        if (root.hasChildNodes()) {
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node n = childNodes.item(i);
                if (n == null || !(n instanceof Element) || !this.hasParameters((Element)n)) continue;
                return true;
            }
        }
        return true;
    }

    private void replaceParameters(Element root, Map<String, String> parameters) {
        int i;
        if (root.hasChildNodes()) {
            NodeList childNodes = root.getChildNodes();
            for (i = 0; i < childNodes.getLength(); ++i) {
                Node n = childNodes.item(i);
                if (n == null || !(n instanceof Element)) continue;
                this.replaceParameters((Element)n, parameters);
            }
        }
        NamedNodeMap attributes = root.getAttributes();
        for (i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if ("style".equalsIgnoreCase(attribute.getNodeName())) {
                String[] keyValues = attribute.getNodeValue().split("\\s*;\\s*");
                StringBuilder newAttribute = new StringBuilder();
                for (String keyValue : keyValues) {
                    String[] kv = keyValue.split("\\s*:\\s*");
                    if (kv.length < 2) continue;
                    String key = kv[0];
                    String value = this.replaceValue(kv[1], parameters);
                    newAttribute.append(key).append(":").append(value).append(";");
                }
                attribute.setNodeValue(newAttribute.toString());
                continue;
            }
            String value = this.replaceValue(attribute.getNodeValue(), parameters);
            attribute.setNodeValue(value);
        }
    }

    private String replaceValue(String value, Map<String, String> parameters) {
        Matcher m = PARAMETER_PATTERN.matcher(value);
        if (m.matches()) {
            String key = m.group(1);
            String newValue = parameters.get(key);
            value = newValue != null ? newValue : (key.contains("width") ? "0" : (key.contains("opacity") || key.contains("alpha") ? "1" : "#000000"));
        }
        return value;
    }

    public static void resetCache() {
        RenderableSVGCache.resetCache();
    }

    @Override
    public void clearCache() {
        RenderableSVGCache.resetCache();
    }

    static {
        formats.add("image/svg");
        formats.add("image/svg-xml");
        formats.add("image/svg+xml");
    }

    static class SVGIcon
    implements Icon {
        private int width;
        private int height;
        RenderableSVG svg;

        public SVGIcon(RenderableSVG svg, int size) {
            this.svg = svg;
            Rectangle2D bounds = svg.bounds;
            double targetWidth = bounds.getWidth();
            double targetHeight = bounds.getHeight();
            if (size > 0) {
                double shapeAspectRatio = bounds.getHeight() > 0.0 && bounds.getWidth() > 0.0 ? bounds.getWidth() / bounds.getHeight() : 1.0;
                targetWidth = shapeAspectRatio * (double)size;
                targetHeight = size;
            }
            this.width = (int)Math.round(targetWidth);
            this.height = (int)Math.round(targetHeight);
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.svg.paint((Graphics2D)g, this.width, this.height, x, y);
        }
    }
}

