/*
 * Decompiled with CFR 0.152.
 */
package com.hashmapinc.tempus.WitsmlObjects.Util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class WitsmlVersionTransformer {
    private String xslTransformationFile;

    public WitsmlVersionTransformer() throws TransformerConfigurationException {
        InputStream stream = this.getClass().getResourceAsStream("/WITSMLverConvert.xslt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        this.xslTransformationFile = reader.lines().collect(Collectors.joining(System.getProperty("line.separator")));
    }

    public String convertVersion(String witsmlInput) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource transformSource = new StreamSource(new StringReader(this.xslTransformationFile));
        Transformer transformer = tFactory.newTransformer(transformSource);
        if (witsmlInput == null) {
            return "";
        }
        if (witsmlInput.equals("")) {
            return "";
        }
        StringReader reader = new StringReader(witsmlInput);
        StreamSource xmlInputFile = new StreamSource(reader);
        StringWriter writer = new StringWriter();
        StreamResult xmlOutputFile = new StreamResult(writer);
        try {
            transformer.setParameter("omit-banner", "YES");
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.transform(xmlInputFile, xmlOutputFile);
        writer.flush();
        return writer.toString();
    }
}

