/*
 * Decompiled with CFR 0.152.
 */
package com.hashmapinc.tempus.WitsmlObjects.v20;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.hashmapinc.tempus.WitsmlObjects.v1311.CsRheometer;
import com.hashmapinc.tempus.WitsmlObjects.v20.ExtensionNameValue;
import com.hashmapinc.tempus.WitsmlObjects.v20.GenericMeasure;
import com.hashmapinc.tempus.WitsmlObjects.v20.RheometerViscosity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Rheometer", namespace="http://www.energistics.org/energyml/data/witsmlv2", propOrder={"tempRheom", "presRheom", "extensionNameValue", "viscosity"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Rheometer {
    @XmlElement(name="TempRheom")
    protected GenericMeasure tempRheom;
    @XmlElement(name="PresRheom")
    protected GenericMeasure presRheom;
    @XmlElement(name="ExtensionNameValue")
    protected List<ExtensionNameValue> extensionNameValue;
    @XmlElement(name="Viscosity")
    protected List<RheometerViscosity> viscosity;
    @XmlAttribute(name="uid", required=true)
    protected String uid;

    public GenericMeasure getTempRheom() {
        return this.tempRheom;
    }

    public void setTempRheom(GenericMeasure value) {
        this.tempRheom = value;
    }

    public GenericMeasure getPresRheom() {
        return this.presRheom;
    }

    public void setPresRheom(GenericMeasure value) {
        this.presRheom = value;
    }

    public List<ExtensionNameValue> getExtensionNameValue() {
        if (this.extensionNameValue == null) {
            this.extensionNameValue = new ArrayList<ExtensionNameValue>();
        }
        return this.extensionNameValue;
    }

    public List<RheometerViscosity> getViscosity() {
        if (this.viscosity == null) {
            this.viscosity = new ArrayList<RheometerViscosity>();
        }
        return this.viscosity;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    public com.hashmapinc.tempus.WitsmlObjects.v1411.CsRheometer to1411CsRheometer() {
        com.hashmapinc.tempus.WitsmlObjects.v1411.CsRheometer dest = new com.hashmapinc.tempus.WitsmlObjects.v1411.CsRheometer();
        dest.setUid(this.getUid());
        if (this.getTempRheom() != null) {
            dest.setTempRheom(this.getTempRheom().to1411GenericMeasure());
        }
        if (this.getPresRheom() != null) {
            dest.setPresRheom(this.getPresRheom().to1411GenericMeasure());
        }
        List<RheometerViscosity> rvs = this.getViscosity();
        rvs.forEach(rv -> {
            switch (rv.getUid()) {
                case "vis100rpm": {
                    dest.setVis100Rpm(rv.getViscosity());
                    break;
                }
                case "vis3rpm": {
                    dest.setVis3Rpm(rv.getViscosity());
                    break;
                }
                case "vis6rpm": {
                    dest.setVis6Rpm(rv.getViscosity());
                    break;
                }
                case "vis200rpm": {
                    dest.setVis200Rpm(rv.getViscosity());
                    break;
                }
                case "vis300rpm": {
                    dest.setVis300Rpm(rv.getViscosity());
                    break;
                }
                case "vis600rpm": {
                    dest.setVis600Rpm(rv.getViscosity());
                }
            }
        });
        if (this.extensionNameValue != null) {
            ArrayList<ExtensionNameValue> destArray = new ArrayList<ExtensionNameValue>();
            for (ExtensionNameValue value : this.extensionNameValue) {
                destArray.add(0, value);
            }
        }
        return dest;
    }

    public CsRheometer to1311CsRheometer() {
        CsRheometer dest = new CsRheometer();
        dest.setUid(this.getUid());
        if (this.getTempRheom() != null) {
            dest.setTempRheom(this.getTempRheom().to1311GenericMeasure());
        }
        if (this.getPresRheom() != null) {
            dest.setPresRheom(this.getPresRheom().to1311GenericMeasure());
        }
        List<RheometerViscosity> rvs = this.getViscosity();
        rvs.forEach(rv -> {
            switch (rv.getUid()) {
                case "vis100rpm": {
                    dest.setVis100Rpm(rv.getViscosity());
                    break;
                }
                case "vis3rpm": {
                    dest.setVis3Rpm(rv.getViscosity());
                    break;
                }
                case "vis6rpm": {
                    dest.setVis6Rpm(rv.getViscosity());
                    break;
                }
                case "vis200rpm": {
                    dest.setVis200Rpm(rv.getViscosity());
                    break;
                }
                case "vis300rpm": {
                    dest.setVis300Rpm(rv.getViscosity());
                    break;
                }
                case "vis600rpm": {
                    dest.setVis600Rpm(rv.getViscosity());
                }
            }
        });
        return dest;
    }
}

