/*
 * Decompiled with CFR 0.152.
 */
package com.hashmapinc.tempus.WitsmlObjects.v20;

import com.hashmapinc.tempus.WitsmlObjects.v1411.CsLocation;
import com.hashmapinc.tempus.WitsmlObjects.v1411.CsTrajectoryStation;
import com.hashmapinc.tempus.WitsmlObjects.v1411.RefNameString;
import com.hashmapinc.tempus.WitsmlObjects.v20.AnglePerLengthMeasure;
import com.hashmapinc.tempus.WitsmlObjects.v20.DataObjectReference;
import com.hashmapinc.tempus.WitsmlObjects.v20.DepthCoord;
import com.hashmapinc.tempus.WitsmlObjects.v20.ExtensionNameValue;
import com.hashmapinc.tempus.WitsmlObjects.v20.LengthMeasure;
import com.hashmapinc.tempus.WitsmlObjects.v20.LinearAccelerationMeasure;
import com.hashmapinc.tempus.WitsmlObjects.v20.MagneticFluxDensityMeasure;
import com.hashmapinc.tempus.WitsmlObjects.v20.PlaneAngleMeasure;
import com.hashmapinc.tempus.WitsmlObjects.v20.RefWellboreTrajectoryStation;
import com.hashmapinc.tempus.WitsmlObjects.v20.StnTrajCorUsed;
import com.hashmapinc.tempus.WitsmlObjects.v20.StnTrajMatrixCov;
import com.hashmapinc.tempus.WitsmlObjects.v20.StnTrajRawData;
import com.hashmapinc.tempus.WitsmlObjects.v20.StnTrajValid;
import com.hashmapinc.tempus.WitsmlObjects.v20.WellLocation;
import com.hashmapinc.tempus.WitsmlObjects.v20.WellVerticalDepthCoord;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TrajectoryStation", namespace="http://www.energistics.org/energyml/data/witsmlv2", propOrder={"manuallyEntered", "target", "dTimStn", "typeTrajStation", "typeSurveyTool", "calcAlgorithm", "md", "tvd", "incl", "azi", "mtf", "gtf", "dispNs", "dispEw", "vertSect", "dls", "rateTurn", "rateBuild", "mdDelta", "tvdDelta", "gravTotalUncert", "dipAngleUncert", "magTotalUncert", "gravAccelCorUsed", "magXAxialCorUsed", "sagCorUsed", "magDrlstrCorUsed", "infieldRefCorUsed", "interpolatedInfieldRefCorUsed", "inHoleRefCorUsed", "axialMagInterferenceCorUsed", "cosagCorUsed", "msaCorUsed", "gravTotalFieldReference", "magTotalFieldReference", "magDipAngleReference", "magModelUsed", "magModelValid", "geoModelUsed", "statusTrajStation", "extensionNameValue", "valid", "matrixCov", "location", "sourceStation", "rawData", "corUsed", "iscwsaToolErrorModel"})
public class TrajectoryStation {
    @XmlElement(name="ManuallyEntered")
    protected Boolean manuallyEntered;
    @XmlElement(name="Target")
    protected String target;
    @XmlElement(name="DTimStn")
    protected String dTimStn;
    @XmlElement(name="TypeTrajStation", required=true)
    @XmlSchemaType(name="string")
    protected String typeTrajStation;
    @XmlElement(name="TypeSurveyTool")
    @XmlSchemaType(name="string")
    protected String typeSurveyTool;
    @XmlElement(name="CalcAlgorithm")
    @XmlSchemaType(name="string")
    protected String calcAlgorithm;
    @XmlElement(name="Md", required=true)
    protected DepthCoord md;
    @XmlElement(name="Tvd")
    protected WellVerticalDepthCoord tvd;
    @XmlElement(name="Incl")
    protected PlaneAngleMeasure incl;
    @XmlElement(name="Azi")
    protected PlaneAngleMeasure azi;
    @XmlElement(name="Mtf")
    protected PlaneAngleMeasure mtf;
    @XmlElement(name="Gtf")
    protected PlaneAngleMeasure gtf;
    @XmlElement(name="DispNs")
    protected LengthMeasure dispNs;
    @XmlElement(name="DispEw")
    protected LengthMeasure dispEw;
    @XmlElement(name="VertSect")
    protected LengthMeasure vertSect;
    @XmlElement(name="Dls")
    protected AnglePerLengthMeasure dls;
    @XmlElement(name="RateTurn")
    protected AnglePerLengthMeasure rateTurn;
    @XmlElement(name="RateBuild")
    protected AnglePerLengthMeasure rateBuild;
    @XmlElement(name="MdDelta")
    protected LengthMeasure mdDelta;
    @XmlElement(name="TvdDelta")
    protected LengthMeasure tvdDelta;
    @XmlElement(name="GravTotalUncert")
    protected LinearAccelerationMeasure gravTotalUncert;
    @XmlElement(name="DipAngleUncert")
    protected PlaneAngleMeasure dipAngleUncert;
    @XmlElement(name="MagTotalUncert")
    protected MagneticFluxDensityMeasure magTotalUncert;
    @XmlElement(name="GravAccelCorUsed")
    protected Boolean gravAccelCorUsed;
    @XmlElement(name="MagXAxialCorUsed")
    protected Boolean magXAxialCorUsed;
    @XmlElement(name="SagCorUsed")
    protected Boolean sagCorUsed;
    @XmlElement(name="MagDrlstrCorUsed")
    protected Boolean magDrlstrCorUsed;
    @XmlElement(name="InfieldRefCorUsed")
    protected Boolean infieldRefCorUsed;
    @XmlElement(name="InterpolatedInfieldRefCorUsed")
    protected Boolean interpolatedInfieldRefCorUsed;
    @XmlElement(name="InHoleRefCorUsed")
    protected Boolean inHoleRefCorUsed;
    @XmlElement(name="AxialMagInterferenceCorUsed")
    protected Boolean axialMagInterferenceCorUsed;
    @XmlElement(name="CosagCorUsed")
    protected Boolean cosagCorUsed;
    @XmlElement(name="MSACorUsed")
    protected Boolean msaCorUsed;
    @XmlElement(name="GravTotalFieldReference")
    protected LinearAccelerationMeasure gravTotalFieldReference;
    @XmlElement(name="MagTotalFieldReference")
    protected MagneticFluxDensityMeasure magTotalFieldReference;
    @XmlElement(name="MagDipAngleReference")
    protected PlaneAngleMeasure magDipAngleReference;
    @XmlElement(name="MagModelUsed")
    protected String magModelUsed;
    @XmlElement(name="MagModelValid")
    protected String magModelValid;
    @XmlElement(name="GeoModelUsed")
    protected String geoModelUsed;
    @XmlElement(name="StatusTrajStation")
    @XmlSchemaType(name="string")
    protected String statusTrajStation;
    @XmlElement(name="ExtensionNameValue")
    protected List<ExtensionNameValue> extensionNameValue;
    @XmlElement(name="Valid")
    protected StnTrajValid valid;
    @XmlElement(name="MatrixCov")
    protected StnTrajMatrixCov matrixCov;
    @XmlElement(name="Location")
    protected List<WellLocation> location;
    @XmlElement(name="SourceStation")
    protected RefWellboreTrajectoryStation sourceStation;
    @XmlElement(name="RawData")
    protected StnTrajRawData rawData;
    @XmlElement(name="CorUsed")
    protected StnTrajCorUsed corUsed;
    @XmlElement(name="IscwsaToolErrorModel")
    protected DataObjectReference iscwsaToolErrorModel;
    @XmlAttribute(name="uid", required=true)
    protected String uid;

    public Boolean isManuallyEntered() {
        return this.manuallyEntered;
    }

    public void setManuallyEntered(Boolean value) {
        this.manuallyEntered = value;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String value) {
        this.target = value;
    }

    public String getDTimStn() {
        return this.dTimStn;
    }

    public void setDTimStn(String value) {
        this.dTimStn = value;
    }

    public String getTypeTrajStation() {
        return this.typeTrajStation;
    }

    public void setTypeTrajStation(String value) {
        this.typeTrajStation = value;
    }

    public String getTypeSurveyTool() {
        return this.typeSurveyTool;
    }

    public void setTypeSurveyTool(String value) {
        this.typeSurveyTool = value;
    }

    public String getCalcAlgorithm() {
        return this.calcAlgorithm;
    }

    public void setCalcAlgorithm(String value) {
        this.calcAlgorithm = value;
    }

    public DepthCoord getMd() {
        return this.md;
    }

    public void setMd(DepthCoord value) {
        this.md = value;
    }

    public WellVerticalDepthCoord getTvd() {
        return this.tvd;
    }

    public void setTvd(WellVerticalDepthCoord value) {
        this.tvd = value;
    }

    public PlaneAngleMeasure getIncl() {
        return this.incl;
    }

    public void setIncl(PlaneAngleMeasure value) {
        this.incl = value;
    }

    public PlaneAngleMeasure getAzi() {
        return this.azi;
    }

    public void setAzi(PlaneAngleMeasure value) {
        this.azi = value;
    }

    public PlaneAngleMeasure getMtf() {
        return this.mtf;
    }

    public void setMtf(PlaneAngleMeasure value) {
        this.mtf = value;
    }

    public PlaneAngleMeasure getGtf() {
        return this.gtf;
    }

    public void setGtf(PlaneAngleMeasure value) {
        this.gtf = value;
    }

    public LengthMeasure getDispNs() {
        return this.dispNs;
    }

    public void setDispNs(LengthMeasure value) {
        this.dispNs = value;
    }

    public LengthMeasure getDispEw() {
        return this.dispEw;
    }

    public void setDispEw(LengthMeasure value) {
        this.dispEw = value;
    }

    public LengthMeasure getVertSect() {
        return this.vertSect;
    }

    public void setVertSect(LengthMeasure value) {
        this.vertSect = value;
    }

    public AnglePerLengthMeasure getDls() {
        return this.dls;
    }

    public void setDls(AnglePerLengthMeasure value) {
        this.dls = value;
    }

    public AnglePerLengthMeasure getRateTurn() {
        return this.rateTurn;
    }

    public void setRateTurn(AnglePerLengthMeasure value) {
        this.rateTurn = value;
    }

    public AnglePerLengthMeasure getRateBuild() {
        return this.rateBuild;
    }

    public void setRateBuild(AnglePerLengthMeasure value) {
        this.rateBuild = value;
    }

    public LengthMeasure getMdDelta() {
        return this.mdDelta;
    }

    public void setMdDelta(LengthMeasure value) {
        this.mdDelta = value;
    }

    public LengthMeasure getTvdDelta() {
        return this.tvdDelta;
    }

    public void setTvdDelta(LengthMeasure value) {
        this.tvdDelta = value;
    }

    public LinearAccelerationMeasure getGravTotalUncert() {
        return this.gravTotalUncert;
    }

    public void setGravTotalUncert(LinearAccelerationMeasure value) {
        this.gravTotalUncert = value;
    }

    public PlaneAngleMeasure getDipAngleUncert() {
        return this.dipAngleUncert;
    }

    public void setDipAngleUncert(PlaneAngleMeasure value) {
        this.dipAngleUncert = value;
    }

    public MagneticFluxDensityMeasure getMagTotalUncert() {
        return this.magTotalUncert;
    }

    public void setMagTotalUncert(MagneticFluxDensityMeasure value) {
        this.magTotalUncert = value;
    }

    public Boolean isGravAccelCorUsed() {
        return this.gravAccelCorUsed;
    }

    public void setGravAccelCorUsed(Boolean value) {
        this.gravAccelCorUsed = value;
    }

    public Boolean isMagXAxialCorUsed() {
        return this.magXAxialCorUsed;
    }

    public void setMagXAxialCorUsed(Boolean value) {
        this.magXAxialCorUsed = value;
    }

    public Boolean isSagCorUsed() {
        return this.sagCorUsed;
    }

    public void setSagCorUsed(Boolean value) {
        this.sagCorUsed = value;
    }

    public Boolean isMagDrlstrCorUsed() {
        return this.magDrlstrCorUsed;
    }

    public void setMagDrlstrCorUsed(Boolean value) {
        this.magDrlstrCorUsed = value;
    }

    public Boolean isInfieldRefCorUsed() {
        return this.infieldRefCorUsed;
    }

    public void setInfieldRefCorUsed(Boolean value) {
        this.infieldRefCorUsed = value;
    }

    public Boolean isInterpolatedInfieldRefCorUsed() {
        return this.interpolatedInfieldRefCorUsed;
    }

    public void setInterpolatedInfieldRefCorUsed(Boolean value) {
        this.interpolatedInfieldRefCorUsed = value;
    }

    public Boolean isInHoleRefCorUsed() {
        return this.inHoleRefCorUsed;
    }

    public void setInHoleRefCorUsed(Boolean value) {
        this.inHoleRefCorUsed = value;
    }

    public Boolean isAxialMagInterferenceCorUsed() {
        return this.axialMagInterferenceCorUsed;
    }

    public void setAxialMagInterferenceCorUsed(Boolean value) {
        this.axialMagInterferenceCorUsed = value;
    }

    public Boolean isCosagCorUsed() {
        return this.cosagCorUsed;
    }

    public void setCosagCorUsed(Boolean value) {
        this.cosagCorUsed = value;
    }

    public Boolean isMSACorUsed() {
        return this.msaCorUsed;
    }

    public void setMSACorUsed(Boolean value) {
        this.msaCorUsed = value;
    }

    public LinearAccelerationMeasure getGravTotalFieldReference() {
        return this.gravTotalFieldReference;
    }

    public void setGravTotalFieldReference(LinearAccelerationMeasure value) {
        this.gravTotalFieldReference = value;
    }

    public MagneticFluxDensityMeasure getMagTotalFieldReference() {
        return this.magTotalFieldReference;
    }

    public void setMagTotalFieldReference(MagneticFluxDensityMeasure value) {
        this.magTotalFieldReference = value;
    }

    public PlaneAngleMeasure getMagDipAngleReference() {
        return this.magDipAngleReference;
    }

    public void setMagDipAngleReference(PlaneAngleMeasure value) {
        this.magDipAngleReference = value;
    }

    public String getMagModelUsed() {
        return this.magModelUsed;
    }

    public void setMagModelUsed(String value) {
        this.magModelUsed = value;
    }

    public String getMagModelValid() {
        return this.magModelValid;
    }

    public void setMagModelValid(String value) {
        this.magModelValid = value;
    }

    public String getGeoModelUsed() {
        return this.geoModelUsed;
    }

    public void setGeoModelUsed(String value) {
        this.geoModelUsed = value;
    }

    public String getStatusTrajStation() {
        return this.statusTrajStation;
    }

    public void setStatusTrajStation(String value) {
        this.statusTrajStation = value;
    }

    public List<ExtensionNameValue> getExtensionNameValue() {
        if (this.extensionNameValue == null) {
            this.extensionNameValue = new ArrayList<ExtensionNameValue>();
        }
        return this.extensionNameValue;
    }

    public StnTrajValid getValid() {
        return this.valid;
    }

    public void setValid(StnTrajValid value) {
        this.valid = value;
    }

    public StnTrajMatrixCov getMatrixCov() {
        return this.matrixCov;
    }

    public void setMatrixCov(StnTrajMatrixCov value) {
        this.matrixCov = value;
    }

    public List<WellLocation> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<WellLocation>();
        }
        return this.location;
    }

    public void setLocation(List<WellLocation> locList) {
        this.location = locList;
    }

    public RefWellboreTrajectoryStation getSourceStation() {
        return this.sourceStation;
    }

    public void setSourceStation(RefWellboreTrajectoryStation value) {
        this.sourceStation = value;
    }

    public StnTrajRawData getRawData() {
        return this.rawData;
    }

    public void setRawData(StnTrajRawData value) {
        this.rawData = value;
    }

    public StnTrajCorUsed getCorUsed() {
        return this.corUsed;
    }

    public void setCorUsed(StnTrajCorUsed value) {
        this.corUsed = value;
    }

    public DataObjectReference getIscwsaToolErrorModel() {
        return this.iscwsaToolErrorModel;
    }

    public void setIscwsaToolErrorModel(DataObjectReference value) {
        this.iscwsaToolErrorModel = value;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    public CsTrajectoryStation to1411CsTrajectoryStation() throws DatatypeConfigurationException {
        CsTrajectoryStation station = new CsTrajectoryStation();
        station.setGravAccelCorUsed(this.isGravAccelCorUsed());
        station.setMagXAxialCorUsed(this.isMagXAxialCorUsed());
        station.setSagCorUsed(this.isSagCorUsed());
        station.setMagDrlstrCorUsed(this.isMagDrlstrCorUsed());
        station.setMagModelUsed(this.getMagModelUsed());
        station.setMagModelValid(this.getMagModelValid());
        station.setGeoModelUsed(this.getGeoModelUsed());
        station.setUid(this.getUid());
        station.setTypeTrajStation(this.getTypeTrajStation());
        station.setStatusTrajStation(this.getStatusTrajStation());
        if (null != this.getDTimStn()) {
            station.setDTimStn(this.getDTimStn());
        }
        if (null != this.getTarget()) {
            RefNameString ref = new RefNameString();
            ref.setValue(this.getTarget());
            station.setTarget(ref);
        }
        if (null != this.getTypeSurveyTool()) {
            station.setTypeSurveyTool(this.getTypeSurveyTool());
        }
        if (null != this.getMd()) {
            station.setMd(this.getMd().to1411MeasuredDepthCoord());
        }
        if (null != this.getTvd()) {
            station.setTvd(this.getTvd().to1411WellVerticalDepthCoord());
        }
        if (null != this.getIncl()) {
            station.setIncl(this.getIncl().to1411PlaneAngleMeasure());
        }
        if (null != this.getAzi()) {
            station.setAzi(this.getAzi().to1411PlaneAngleMeasure());
        }
        if (null != this.getMtf()) {
            station.setMtf(this.getMtf().to1411PlaneAngleMeasure());
        }
        if (null != this.getGtf()) {
            station.setGtf(this.getGtf().to1411PlaneAngleMeasure());
        }
        if (null != this.getDispNs()) {
            station.setDispNs(this.getDispNs().to1411LengthMeasure());
        }
        if (null != this.getDispEw()) {
            station.setDispEw(this.getDispEw().to1411LengthMeasure());
        }
        if (null != this.getVertSect()) {
            station.setVertSect(this.getVertSect().to1411LengthMeasure());
        }
        if (null != this.getDls()) {
            station.setDls(this.getDls().to1411AnglePerLengthMeasure());
        }
        if (null != this.getRateTurn()) {
            station.setRateTurn(this.getRateTurn().to1411AnglePerLengthMeasure());
        }
        if (null != this.getRateBuild()) {
            station.setRateBuild(this.getRateBuild().to1411AnglePerLengthMeasure());
        }
        if (null != this.getMdDelta()) {
            station.setMdDelta(this.getMdDelta().to1411LengthMeasure());
        }
        if (null != this.getTvdDelta()) {
            station.setTvdDelta(this.getTvdDelta().to1411LengthMeasure());
        }
        if (null != this.getGravTotalUncert()) {
            station.setGravTotalUncert(this.getGravTotalUncert().to1411AnglePerLengthMeasure());
        }
        if (null != this.getDipAngleUncert()) {
            station.setDipAngleUncert(this.getDipAngleUncert().to1411PlaneAngleMeasure());
        }
        if (null != this.getMagTotalUncert()) {
            station.setMagTotalUncert(this.getMagTotalUncert().to1411MagneticInductionMeasure());
        }
        if (null != this.getGravTotalFieldReference()) {
            station.setGravTotalFieldReference(this.getGravTotalFieldReference().to1411AnglePerLengthMeasure());
        }
        if (null != this.getMagTotalFieldReference()) {
            station.setMagTotalFieldReference(this.getMagTotalFieldReference().to1411MagneticInductionMeasure());
        }
        if (null != this.getMagDipAngleReference()) {
            station.setMagDipAngleReference(this.getMagDipAngleReference().to1411PlaneAngleMeasure());
        }
        if (null != this.getRawData()) {
            station.setRawData(this.getRawData().to1411CsStnTrajRawData());
        }
        if (null != this.getCorUsed()) {
            station.setCorUsed(this.getCorUsed().to1411CsStnTrajCorUsed());
        }
        if (null != this.getValid()) {
            station.setValid(this.getValid().to1411CsStnTrajValid());
        }
        if (null != this.getMatrixCov()) {
            station.setMatrixCov(this.getMatrixCov().to1411CsStnTrajMatrixCov());
        }
        if (null != this.getSourceStation()) {
            station.setSourceStation(this.getSourceStation().to1411CsRefWellboreTrajectoryStation());
        }
        if (null != this.getLocation()) {
            ArrayList<CsLocation> destLocations = new ArrayList<CsLocation>();
            for (WellLocation srcLocation : this.getLocation()) {
                destLocations.add(srcLocation.to1411CsLocation());
            }
            station.setLocation(destLocations);
        }
        return station;
    }
}

