/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.eastwood;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.eastwood.GLabelledAxis;
import org.jfree.text.TextBlock;
import org.jfree.ui.RectangleEdge;

class GCategoryAxis
extends CategoryAxis
implements GLabelledAxis {
    List labels = null;

    public GCategoryAxis() {
        this.setTickLabelPaint(Color.gray);
        this.setTickLabelFont(new Font("Dialog", 0, 11));
    }

    @Override
    public void setTickLabels(List labels) {
        this.labels = labels;
    }

    public List refreshTicks(Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<CategoryTick> ticks = new ArrayList<CategoryTick>();
        if (dataArea.getHeight() <= 0.0 || dataArea.getWidth() < 0.0) {
            return ticks;
        }
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        ArrayList categories = null;
        if (this.labels == null) {
            categories = plot.getCategories();
        } else {
            categories = new ArrayList(this.labels);
            if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                Collections.reverse(categories);
            }
        }
        double max = 0.0;
        if (categories != null) {
            CategoryLabelPosition position = this.getCategoryLabelPositions().getLabelPosition(edge);
            float r = this.getMaximumCategoryLabelWidthRatio();
            if ((double)r <= 0.0) {
                r = position.getWidthRatio();
            }
            float l = 0.0f;
            l = position.getWidthType() == CategoryLabelWidthType.CATEGORY ? (float)this.calculateCategorySize(categories.size(), dataArea, edge) : (RectangleEdge.isLeftOrRight((RectangleEdge)edge) ? (float)dataArea.getWidth() : (float)dataArea.getHeight());
            int categoryIndex = 0;
            for (Comparable category : categories) {
                TextBlock label = this.createLabel(category, l * r, edge, g2);
                if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
                    max = Math.max(max, this.calculateTextBlockHeight(label, position, g2));
                } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
                    max = Math.max(max, this.calculateTextBlockWidth(label, position, g2));
                }
                CategoryTick tick = new CategoryTick(category, label, position.getLabelAnchor(), position.getRotationAnchor(), position.getAngle());
                ticks.add(tick);
                ++categoryIndex;
            }
        }
        state.setMax(max);
        return ticks;
    }

    @Override
    public void setTickLabelPositions(List values) {
    }
}

