/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.eastwood;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;

class GCategoryPlot
extends CategoryPlot {
    private double xAxisStepSize = 0.0;
    private double yAxisStepSize = 0.0;

    public void setXAxisStepSize(double axisStepSize) {
        this.xAxisStepSize = axisStepSize;
    }

    public void setYAxisStepSize(double axisStepSize) {
        this.yAxisStepSize = axisStepSize;
    }

    protected void drawDomainGridlines(Graphics2D g2, Rectangle2D dataArea) {
        if (this.xAxisStepSize > 0.0) {
            super.drawDomainGridlines(g2, dataArea);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawRangeGridlines(Graphics2D g2, Rectangle2D dataArea, List ticks) {
        if (this.isRangeGridlinesVisible()) {
            ValueAxis axis;
            Stroke gridStroke = this.getRangeGridlineStroke();
            Paint gridPaint = this.getRangeGridlinePaint();
            if (gridStroke != null && gridPaint != null && (axis = this.getRangeAxis()) != null) {
                double lower = axis.getRange().getLowerBound();
                double upper = axis.getRange().getUpperBound();
                for (double y = lower; y <= upper; y += this.yAxisStepSize) {
                    Paint paint = gridPaint;
                    if ((y == lower || y == upper) && gridPaint instanceof Color) {
                        Color c = (Color)gridPaint;
                        paint = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha() / 3);
                    }
                    try {
                        this.setRangeGridlinePaint(paint);
                        this.getRenderer().drawRangeGridline(g2, (CategoryPlot)this, this.getRangeAxis(), dataArea, y);
                        continue;
                    }
                    finally {
                        this.setRangeGridlinePaint(gridPaint);
                    }
                }
            }
        }
    }
}

