/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.audit;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.user.User;
import com.stratadata.model3.user.UserService;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;

public class AuditImpl
implements Audit {
    private int creatorID;
    private LocalDate created;
    private int modifierID;
    private LocalDate modified;
    private int updaterID;
    private Instant updated;

    @Override
    public int getCreatorID() {
        return this.creatorID;
    }

    public void setCreatorID(int creatorID) {
        this.creatorID = creatorID;
    }

    @Override
    public Optional<User> getCreator() {
        if (this.creatorID == 0) {
            return Optional.empty();
        }
        throw new IllegalStateException("Cannot access user information");
    }

    @Override
    public LocalDate getCreated() {
        return this.created;
    }

    public void setCreated(LocalDate created) {
        this.created = created;
    }

    @Override
    public int getModifierID() {
        return this.modifierID;
    }

    public void setModifierID(int modifierID) {
        this.modifierID = modifierID;
    }

    @Override
    public Optional<User> getModifier() {
        if (this.modifierID == 0) {
            return Optional.empty();
        }
        throw new IllegalStateException("Cannot access user information");
    }

    @Override
    public LocalDate getModified() {
        return this.modified;
    }

    public void setModified(LocalDate modified) {
        this.modified = modified;
    }

    @Override
    public int getUpdaterID() {
        return this.updaterID;
    }

    public void setUpdaterID(int updaterID) {
        this.updaterID = updaterID;
    }

    @Override
    public Instant getUpdated() {
        return this.updated;
    }

    public void setUpdated(Instant updated) {
        this.updated = updated;
    }

    public static AuditImpl getAuditUpdate(Audit source, UserService userService, Instant databaseServerDate, boolean preserveModification) {
        AuditImpl update = new AuditImpl();
        update.setCreatorID(source == null || source.getCreatorID() == 0 ? userService.getCurrentUserID() : source.getCreatorID());
        update.setCreated(source == null || source.getCreated() == null ? LocalDate.now() : source.getCreated());
        update.setModifierID(source == null || source.getModifierID() == 0 || !preserveModification ? userService.getCurrentUserID() : source.getModifierID());
        update.setModified(source == null || source.getModified() == null || !preserveModification ? LocalDate.now() : source.getModified());
        update.setUpdaterID(userService.getCurrentUserID());
        update.setUpdated(Objects.requireNonNullElse(databaseServerDate, Instant.now()));
        return update;
    }

    public void copyFields(Audit source) {
        this.setCreated(source.getCreated());
        this.setCreatorID(source.getCreatorID());
        this.setModified(source.getModified());
        this.setModifierID(source.getModifierID());
        this.setUpdated(source.getUpdated());
        this.setUpdaterID(source.getUpdaterID());
    }
}

