/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.event;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.DictionaryEventType;
import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class DictionaryEvent {
    private final int evID;
    private String name = "";
    private String abr;
    private String description;
    private Discipline disc;
    private boolean generate = false;
    private final DictionaryEventType type = new DictionaryEventType();

    public DictionaryEvent() {
        this.evID = 0;
    }

    public DictionaryEvent(int evID) {
        this.evID = evID;
    }

    public boolean isPermitted(EventType eventType) {
        return this.type.isPermitted(eventType);
    }

    public String toString() {
        return this.toString(true, EventContext.WELL, false, true);
    }

    private String toNameString(boolean useAbr, boolean useNameWithAbr) {
        if (useAbr && this.getAbr().isPresent()) {
            if (useNameWithAbr) {
                return this.name + " " + this.abr;
            }
            return this.abr;
        }
        return this.name;
    }

    public String toString(EventType evType, EventContext context, boolean useAbr, boolean useNameWithAbr) {
        return (this.getPrefix(evType, context, true).map(p -> p + " ").orElse("") + this.toNameString(useAbr, useNameWithAbr)).trim();
    }

    public String toString(boolean usePrefix, EventContext context, boolean useAbr, boolean useNameWithAbr) {
        StringBuilder sb = new StringBuilder();
        if (usePrefix) {
            sb.append(this.getPrefix(context)).append(" ");
        }
        return sb.append(this.toNameString(useAbr, useNameWithAbr)).toString();
    }

    public String getPrefix(EventContext context) {
        LinkedList prefixes = new LinkedList();
        Stream.of(EventType.values()).forEach(evType -> {
            if (this.type.isPermitted((EventType)((Object)evType))) {
                prefixes.add(this.type.prefix((EventType)((Object)evType), context).orElse(evType.toStringStandalone(context)));
            }
        });
        return String.join((CharSequence)"/", prefixes);
    }

    public Optional<String> getPrefix(EventType evType, EventContext context, boolean useDefault) {
        if (!this.type.isPermitted(evType)) {
            return Optional.empty();
        }
        Optional<String> prefix = this.type.prefix(evType, context);
        if (!prefix.isPresent() && useDefault) {
            prefix = Optional.of(evType.toString(context));
        }
        return prefix;
    }

    public int getEvID() {
        return this.evID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Objects.requireNonNull(name, "Event name cannot be null");
        this.name = name.trim();
    }

    public Optional<String> getAbr() {
        return Optional.ofNullable(this.abr);
    }

    public void setAbr(String abr) {
        if (abr != null && (abr = abr.trim()).isEmpty()) {
            abr = null;
        }
        this.abr = abr;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(String description) {
        if (description != null && (description = description.trim()).isEmpty()) {
            description = null;
        }
        this.description = description;
    }

    public Discipline getDiscipline() {
        return this.disc;
    }

    public void setDisc(Discipline disc) {
        this.disc = disc;
    }

    public boolean isGenerate() {
        return this.generate;
    }

    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public void setUpType(EventType type, boolean permitted, String wellPrefix, String schemePrefix) {
        this.type.setUpType(type, permitted, wellPrefix, schemePrefix);
    }

    public boolean isFunctionallyEquivalentTo(DictionaryEvent rhs) {
        return this.isFunctionallyEquivalentTo(rhs, false);
    }

    public boolean isFunctionallyEquivalentTo(DictionaryEvent rhs, boolean asymmetricTypes) {
        Objects.requireNonNull(rhs);
        if (!this.name.equalsIgnoreCase(rhs.name)) {
            return false;
        }
        if (!asymmetricTypes) {
            return this.type.equals(rhs.type);
        }
        for (EventType t : EventType.values()) {
            if (rhs.isPermitted(t) && !this.isPermitted(t)) {
                return false;
            }
            for (EventContext c : EventContext.values()) {
                String thisPfx;
                String rhsPfx = DictionaryEventType.trimCommonPrefixToNull(rhs.getPrefix(t, c, false).orElse(null), t, c);
                if (Objects.equals(rhsPfx, thisPfx = DictionaryEventType.trimCommonPrefixToNull(this.getPrefix(t, c, false).orElse(null), t, c))) continue;
                return false;
            }
        }
        return true;
    }

    public void copyFrom(DictionaryEvent rhs) {
        this.setName(rhs.name);
        this.setAbr(rhs.abr);
        this.setDescription(rhs.description);
        this.setGenerate(rhs.generate);
        this.setDisc(rhs.disc);
        for (EventType evType : EventType.values()) {
            this.type.setUpType(evType, rhs.isPermitted(evType), rhs.type.prefix(evType, EventContext.WELL).orElse(null), rhs.type.prefix(evType, EventContext.SCHEME).orElse(null));
        }
    }

    public static DictionaryEvent copyOf(DictionaryEvent rhs) {
        DictionaryEvent newEvent = new DictionaryEvent(rhs.evID);
        newEvent.copyFrom(rhs);
        return newEvent;
    }
}

