/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.event;

import com.stratadata.model3.event.EventContext;

public final class EventType
extends Enum<EventType> {
    public static final /* enum */ EventType TOP = new EventType('F', false, "Top");
    public static final /* enum */ EventType BASE = new EventType('L', false, "Base");
    public static final /* enum */ EventType SINGLE = new EventType('S', true, "Single");
    private final char charType;
    private final boolean isSingle;
    private final String displayName;
    private String prefixWell;
    private String prefixScheme;
    private static final /* synthetic */ EventType[] $VALUES;

    public static EventType[] values() {
        return (EventType[])$VALUES.clone();
    }

    public static EventType valueOf(String name) {
        return Enum.valueOf(EventType.class, name);
    }

    private EventType(char charType, boolean isSingle, String displayName) {
        this.charType = charType;
        this.isSingle = isSingle;
        this.displayName = displayName;
    }

    public char getChar() {
        return this.charType;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public static void setPrefixes(String f_well, String l_well, String f_scheme, String l_scheme, boolean useSinglePrefix) {
        EventType.TOP.prefixWell = EventType.transformPrefix(f_well);
        EventType.BASE.prefixWell = EventType.transformPrefix(l_well);
        EventType.TOP.prefixScheme = EventType.transformPrefix(f_scheme);
        EventType.BASE.prefixScheme = EventType.transformPrefix(l_scheme);
        EventType.SINGLE.prefixWell = useSinglePrefix ? null : "";
        EventType.SINGLE.prefixScheme = useSinglePrefix ? null : "";
    }

    public static String getDefaultPrefix(EventType eventType, EventContext eventContext) {
        switch (eventType.ordinal()) {
            case 0: {
                switch (eventContext) {
                    case WELL: {
                        return EventType.TOP.prefixWell;
                    }
                    case SCHEME: {
                        return EventType.TOP.prefixScheme;
                    }
                }
                break;
            }
            case 1: {
                switch (eventContext) {
                    case WELL: {
                        return EventType.BASE.prefixWell;
                    }
                    case SCHEME: {
                        return EventType.BASE.prefixScheme;
                    }
                }
                break;
            }
            case 2: {
                switch (eventContext) {
                    case WELL: {
                        return EventType.SINGLE.prefixWell;
                    }
                    case SCHEME: {
                        return EventType.SINGLE.prefixScheme;
                    }
                }
            }
        }
        return null;
    }

    private static String transformPrefix(String prefix) {
        if (prefix != null && (prefix = prefix.trim()).isEmpty()) {
            prefix = null;
        }
        return prefix;
    }

    public String toString() {
        if (this.prefixWell == null && this.prefixScheme == null || this.prefixWell.isEmpty() && this.prefixScheme.isEmpty()) {
            return this.displayName;
        }
        if (this.prefixWell.equals(this.prefixScheme)) {
            return this.prefixWell;
        }
        return this.prefixWell + "/" + this.prefixScheme;
    }

    public String toString(EventContext context) {
        switch (context) {
            default: {
                return this.prefixWell != null ? this.prefixWell : this.displayName;
            }
            case SCHEME: 
        }
        return this.prefixScheme != null ? this.prefixScheme : this.displayName;
    }

    public String toStringStandalone(EventContext context) {
        String s = this.toString(context);
        if (s.isEmpty()) {
            s = this.displayName;
        }
        return s;
    }

    public static EventType getType(String value) {
        if (value == null || value.trim().isEmpty() || value.equalsIgnoreCase("Single") || value.equals("0") || value.equals("S")) {
            return SINGLE;
        }
        if (value.equalsIgnoreCase("LDO") || value.equalsIgnoreCase("FAD") || value.toUpperCase().startsWith("BASE")) {
            return BASE;
        }
        if (value.equalsIgnoreCase("FDO") || value.equalsIgnoreCase("LAD") || value.toUpperCase().startsWith("TOP")) {
            return TOP;
        }
        if (value.charAt(0) == 'L') {
            return BASE;
        }
        if (value.charAt(0) == 'F') {
            return TOP;
        }
        assert (false);
        return TOP;
    }

    public static EventType parseType(String value) {
        if (value == null) {
            return null;
        }
        switch (value.trim().toUpperCase()) {
            case "LDO": 
            case "LO": 
            case "FAD": 
            case "BASE": {
                return BASE;
            }
            case "FDO": 
            case "FO": 
            case "LAD": 
            case "TOP": {
                return TOP;
            }
        }
        return null;
    }

    private static /* synthetic */ EventType[] $values() {
        return new EventType[]{TOP, BASE, SINGLE};
    }

    static {
        $VALUES = EventType.$values();
    }
}

