/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.project;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.validation.Ident;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.Validatable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Validatable
public class Project
implements Comparable<Project>,
Audited {
    private final int projID;
    @NotEmptyString
    @LimitedLengthString
    private String name = "";
    @LimitedLengthString
    private String description;
    private Audit audit = new AuditImpl();

    public Project(int projID) {
        this.projID = projID;
    }

    public Project(int projID, String name, String description) {
        this.projID = projID;
        this.name = name;
        this.description = description;
    }

    @Ident
    public int getID() {
        return this.projID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(name, ""));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.trimToNull((String)description);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Project p) {
        if (p instanceof Project) {
            return this.name.compareToIgnoreCase(p.name);
        }
        return 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.projID;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return this.projID == other.projID;
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }
}

