/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.scheme;

public enum Confidence {
    CONFIDENT(0, "Confident"),
    PROBABLE(33, "Probable"),
    POSSIBLE(66, "Possible");

    private final int percent;
    private final String name;

    private Confidence(int percent, String name) {
        this.percent = percent;
        this.name = name;
    }

    public int getDBint() {
        return this.percent;
    }

    public String toString() {
        return this.name;
    }

    public static Confidence getConfidence(int percent) {
        Confidence lastConf = null;
        for (Confidence conf : Confidence.values()) {
            if (lastConf == null) {
                lastConf = conf;
                continue;
            }
            if (percent <= lastConf.percent) break;
            lastConf = conf;
        }
        return lastConf;
    }

    public static Confidence getConfidence(String confidence) {
        for (Confidence conf : Confidence.values()) {
            if (!conf.name.equalsIgnoreCase(confidence)) continue;
            return conf;
        }
        return CONFIDENT;
    }

    public static Confidence getMaxUnconfidence(int percent) {
        for (int i = Confidence.values().length - 1; i >= 0; --i) {
            if (percent < Confidence.values()[i].percent) continue;
            return Confidence.values()[i];
        }
        return CONFIDENT;
    }
}

