/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.scheme;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.scheme.IgdType;
import com.stratadata.model3.scheme.StratigraphicUnit;
import com.stratadata.model3.scheme.StratigraphicUnitService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class StratigraphicScheme
implements StratigraphicUnitService,
Audited {
    private final int schID;
    private final IgdType igdType;
    private String name = "";
    private String comments = "";
    private boolean archived;
    private Audit audit = new AuditImpl();
    private List<StratigraphicUnit> units = new ArrayList<StratigraphicUnit>();

    public StratigraphicScheme(int schID, IgdType igdType) {
        this.schID = schID;
        this.igdType = igdType;
    }

    public int getSchID() {
        return this.schID;
    }

    public IgdType getIgdType() {
        return this.igdType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(name, ""));
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(comments, ""));
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public void setUnits(List<StratigraphicUnit> units) {
        this.units = Objects.requireNonNullElse(units, new ArrayList());
    }

    public Optional<StratigraphicUnit> findUnit(int unitID) {
        return this.findUnit(this.schID, unitID);
    }

    @Override
    public Optional<StratigraphicUnit> findUnit(int schID, int unitID) {
        if (schID != this.schID) {
            return Optional.empty();
        }
        return this.units.stream().filter(unit -> unit.getUnitID() == unitID).findFirst();
    }

    public List<StratigraphicUnit> getUnits() {
        return this.units;
    }

    @Override
    public List<StratigraphicUnit> getUnits(int schID) {
        if (schID != this.schID) {
            return Collections.emptyList();
        }
        return this.getUnits();
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    public void setAudit(Audit audit) {
        this.audit = Objects.requireNonNullElse(audit, new AuditImpl());
    }
}

