/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.Taxon;
import java.util.Comparator;

public class TaxonComparator
implements Comparator<Taxon> {
    final boolean compareCategory;
    final boolean compareGenus;
    final boolean compareAlphaCode;

    private TaxonComparator(boolean compareCategory, boolean compareGenus, boolean compareAlphaCode) {
        this.compareCategory = compareCategory;
        this.compareGenus = compareGenus;
        this.compareAlphaCode = compareAlphaCode;
    }

    public static TaxonComparator compareCategory() {
        return new TaxonComparator(true, true, false);
    }

    public static TaxonComparator compareGenus() {
        return new TaxonComparator(false, true, false);
    }

    public static TaxonComparator compareSpecies() {
        return new TaxonComparator(false, false, false);
    }

    public static TaxonComparator compareAlphaCode() {
        return new TaxonComparator(false, true, true);
    }

    @Override
    public int compare(Taxon o1, Taxon o2) {
        int val = 0;
        if (o1 != null && o2 != null) {
            if (this.compareCategory) {
                val = TaxonComparator.compareCategory(o1.getCategory().orElse(null), o2.getCategory().orElse(null));
            }
            if (val == 0 && this.compareAlphaCode) {
                val = TaxonComparator.compareAlphaCode(o1, o2);
            }
            if (val == 0 && this.compareGenus) {
                val = TaxonComparator.compareGenus(o1.getGenus(), o2.getGenus());
            }
            if (val == 0) {
                val = TaxonComparator.compareSpecies(o1, o2);
            }
            return val;
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        return -1;
    }

    private static int compareCategory(Category o1, Category o2) {
        return Category.compare(o1, o2);
    }

    private static int compareGenus(Genus o1, Genus o2) {
        if (o1 != null && o2 != null) {
            if (!o1.getGenusName().equals(o2.getGenusName())) {
                return o1.getGenusName().compareToIgnoreCase(o2.getGenusName());
            }
            if (!o1.getSubGenus().equals(o2.getSubGenus())) {
                return o1.getSubGenus().compareToIgnoreCase(o2.getSubGenus());
            }
            for (int i = 0; i < 4; ++i) {
                if (o1.getQualifier(i).equals(o2.getQualifier(i))) continue;
                return o1.getQualifier(i).toString().compareToIgnoreCase(o2.getQualifier(i).toString());
            }
            return 0;
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        return -1;
    }

    private static int compareSpecies(Taxon o1, Taxon o2) {
        int o2Undiff;
        int o1Undiff = o1.isUndifferentiated() ? 1 : 0;
        int n = o2Undiff = o2.isUndifferentiated() ? 1 : 0;
        if (o1Undiff != o2Undiff) {
            return o2Undiff - o1Undiff;
        }
        if (!o1.getSpecies().equals(o2.getSpecies())) {
            return o1.getSpecies().compareToIgnoreCase(o2.getSpecies());
        }
        if (!o1.getSubSpecies().equals(o2.getSubSpecies())) {
            return o1.getSubSpecies().compareToIgnoreCase(o2.getSubSpecies());
        }
        for (int i = 4; i < 8; ++i) {
            if (o1.getQualifier(i).equals(o2.getQualifier(i))) continue;
            return o1.getQualifier(i).toString().compareToIgnoreCase(o2.getQualifier(i).toString());
        }
        return 0;
    }

    private static int compareAlphaCode(Taxon o1, Taxon o2) {
        return o1.getAlphaCode().compareToIgnoreCase(o2.getAlphaCode());
    }
}

