/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.util.process.ProgressMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TaxonServiceImpl
implements CategoryService,
GenusService,
TaxonService {
    private final TreeMap<String, Category> cats = new TreeMap();
    private final HashMap<Integer, Genus> genera = new HashMap();
    private final HashMap<Integer, Taxon> taxa = new HashMap();

    @Override
    public List<Category> getCategoryList() {
        return this.cats.values().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public Optional<Category> findCategory(String mnemonic) {
        return Optional.ofNullable(this.cats.get(mnemonic.toUpperCase()));
    }

    @Override
    public Optional<Category> findCategoryOrSuperCategory(String mnemonic) {
        mnemonic = mnemonic.toUpperCase();
        Category superCat = this.cats.get(mnemonic);
        while (superCat == null && mnemonic.length() > 1) {
            superCat = this.cats.get(mnemonic);
            mnemonic = mnemonic.substring(0, mnemonic.length() - 1);
        }
        return Optional.ofNullable(superCat);
    }

    @Override
    public Category addCategory(Category category) {
        if (this.findCategory(category.getMnemonic()).isPresent()) {
            throw new IllegalArgumentException("Category already exists");
        }
        this.cats.put(category.getMnemonic(), category);
        return category;
    }

    @Override
    public void updateCategory(String mnemonic, Category newCategory) {
        if (!this.cats.containsKey(mnemonic)) {
            throw new IllegalArgumentException("Cannot update category: " + mnemonic);
        }
        if (!mnemonic.equals(newCategory.getMnemonic())) {
            this.cats.remove(mnemonic);
        }
        this.cats.put(newCategory.getMnemonic(), newCategory);
    }

    @Override
    public void deleteCategory(String mnemonic) {
        if (!this.cats.containsKey(mnemonic)) {
            throw new IllegalArgumentException("Cannot update category: " + mnemonic);
        }
        this.cats.remove(mnemonic);
    }

    @Override
    public Optional<Taxon> findTaxon(int specID) {
        return Optional.ofNullable(this.taxa.get(specID));
    }

    @Override
    public List<Taxon> getAllTaxa() {
        return new ArrayList<Taxon>(this.taxa.values());
    }

    @Override
    public Optional<Genus> findGenus(int genID) {
        return Optional.ofNullable(this.genera.get(genID));
    }

    @Override
    public Genus addGenus(Genus toAdd) {
        if (toAdd.getCategory() == null) {
            throw new IllegalArgumentException("Cannot add genus with null Category");
        }
        if (toAdd.getGenID() < 1) {
            int ID = this.genera.keySet().stream().max(Integer::compareTo).orElse(0) + 1;
            Genus target = new Genus(ID);
            Genus.copyFields(target, toAdd);
            toAdd = target;
        } else if (this.genera.containsKey(toAdd.getGenID())) {
            throw new IllegalArgumentException("Genus already exists");
        }
        Genus genus = toAdd;
        this.findCategory(genus.getCategory().getMnemonic()).ifPresentOrElse(genus::setCategory, () -> this.addCategory(genus.getCategory()));
        this.genera.put(genus.getGenID(), genus);
        return genus;
    }

    @Override
    public Taxon addTaxon(Taxon toAdd) {
        if (toAdd.getGenus() == null || toAdd.getGenus().getCategory() == null) {
            throw new IllegalArgumentException("Cannot add taxon with invalid Genus");
        }
        if (toAdd.getSpecID() < 1) {
            int ID = this.taxa.keySet().stream().max(Integer::compareTo).orElse(0) + 1;
            Taxon target = new Taxon(ID);
            Taxon.copyFields(target, toAdd);
            toAdd = target;
        } else if (this.taxa.containsKey(toAdd.getSpecID())) {
            throw new IllegalArgumentException("Taxon already exists");
        }
        Taxon taxon = toAdd;
        this.findGenus(toAdd.getGenus().getGenID()).ifPresentOrElse(taxon::setGenus, () -> taxon.setGenus(this.addGenus(taxon.getGenus())));
        this.taxa.put(taxon.getSpecID(), taxon);
        return taxon;
    }

    @Override
    public List<Taxon> findMatchingTaxa(Taxon lookup, Discipline discipline, SearchMode searchMode) {
        List<Predicate<Genus>> genusConditions = this.getGenusSearchConditions(lookup.getGenus(), searchMode);
        List<Predicate<Taxon>> taxonConditions = this.getTaxonSearchConditions(lookup, discipline, searchMode);
        Predicate<Genus> genusPredicate = genusConditions.stream().reduce(x -> true, Predicate::and);
        return this.taxa.values().stream().filter(taxon -> genusPredicate.test(taxon.getGenus())).filter(taxonConditions.stream().reduce(x -> true, Predicate::and)).collect(Collectors.toList());
    }

    @Override
    public List<Genus> findMatchingGenera(Genus lookup, SearchMode searchMode) {
        List<Predicate<Genus>> conditions = this.getGenusSearchConditions(lookup, searchMode);
        return this.genera.values().stream().filter(conditions.stream().reduce(x -> true, Predicate::and)).collect(Collectors.toList());
    }

    private List<Predicate<Genus>> getGenusSearchConditions(Genus lookup, SearchMode searchMode) {
        boolean exactMatch = searchMode == SearchMode.LOOKUP;
        BiFunction<String, String, Boolean> equalsFunction = String::equalsIgnoreCase;
        BiFunction<String, String, Boolean> startsWithFunction = (s1, s2) -> s1.toUpperCase().startsWith(s2.toUpperCase());
        BiFunction<String, String, Boolean> containsFunction = (s1, s2) -> StringUtils.containsIgnoreCase((CharSequence)s1, (CharSequence)s2);
        BiFunction<String, String, Boolean> compareStringsFunction = exactMatch ? equalsFunction : startsWithFunction;
        ArrayList<Predicate<Genus>> conditions = new ArrayList<Predicate<Genus>>();
        if (lookup.getCategory() != null) {
            conditions.add(genus -> genus.getCategory().equals(lookup.getCategory()));
        }
        if (!lookup.getGenusName().isEmpty()) {
            conditions.add(genus -> (Boolean)compareStringsFunction.apply(genus.getGenusName(), lookup.getGenusName()));
        }
        if (!lookup.getSubGenus().isEmpty()) {
            conditions.add(genus -> (Boolean)compareStringsFunction.apply(genus.getSubGenus(), lookup.getSubGenus()));
        }
        for (int i = 0; i < 4; ++i) {
            int p = i;
            if (exactMatch) {
                conditions.add(genus -> (Boolean)equalsFunction.apply(genus.getQualifier(p).toString(false), lookup.getQualifier(p).toString(false)));
                continue;
            }
            if (!lookup.getQualifier(i).hasQuals()) continue;
            conditions.add(genus -> (Boolean)containsFunction.apply(genus.getQualifier(p).toString(false), lookup.getQualifier(p).toString(false)));
        }
        return conditions;
    }

    private List<Predicate<Taxon>> getTaxonSearchConditions(Taxon lookup, Discipline disc, SearchMode searchMode) {
        boolean exactMatch = searchMode == SearchMode.LOOKUP;
        BiFunction<String, String, Boolean> equalsFunction = String::equalsIgnoreCase;
        BiFunction<String, String, Boolean> startsWithFunction = (s1, s2) -> s1.toUpperCase().startsWith(s2.toUpperCase());
        BiFunction<String, String, Boolean> containsFunction = (s1, s2) -> StringUtils.containsIgnoreCase((CharSequence)s1, (CharSequence)s2);
        BiFunction<String, String, Boolean> compareStringsFunction = exactMatch ? equalsFunction : startsWithFunction;
        ArrayList<Predicate<Taxon>> conditions = new ArrayList<Predicate<Taxon>>();
        if (!lookup.getSpecies().isEmpty()) {
            conditions.add(taxon -> (Boolean)compareStringsFunction.apply(taxon.getSpecies(), lookup.getSpecies()));
        }
        if (!lookup.getSubSpecies().isEmpty()) {
            conditions.add(taxon -> (Boolean)compareStringsFunction.apply(taxon.getSubSpecies(), lookup.getSubSpecies()));
        }
        for (int i = 0; i < 4; ++i) {
            int p = i;
            if (exactMatch) {
                conditions.add(genus -> (Boolean)equalsFunction.apply(genus.getQualifier(p).toString(false), lookup.getQualifier(p).toString(false)));
                continue;
            }
            if (!lookup.getQualifier(i).hasQuals()) continue;
            conditions.add(genus -> (Boolean)containsFunction.apply(genus.getQualifier(p).toString(false), lookup.getQualifier(p).toString(false)));
        }
        return conditions;
    }

    @Override
    public Map<String, Long> getCategoryOccurrences() {
        return this.genera.values().stream().map(Genus::getCategory).collect(Collectors.groupingBy(Category::getMnemonic, Collectors.counting()));
    }

    @Override
    public int getGenusCount() {
        return this.genera.size();
    }

    @Override
    public int getTaxonCount() {
        return this.taxa.size();
    }

    @Override
    public void updateGenus(int genID, Genus toUpdate) {
        Genus target = this.genera.get(genID);
        if (target == null) {
            throw new IllegalArgumentException("Attempt to update untracked Genus");
        }
        if (toUpdate.getCategory() == null) {
            throw new IllegalArgumentException("Attempt to update Genus Category to null");
        }
        Genus.copyFields(target, toUpdate);
    }

    @Override
    public void updateTaxon(int specID, Taxon toUpdate) {
        Taxon target = this.taxa.get(specID);
        if (target == null) {
            throw new IllegalArgumentException("Attempt to update untracked Taxon");
        }
        if (toUpdate.getGenus() == null) {
            throw new IllegalArgumentException("Attempt to update Taxon Genus to null");
        }
        Taxon.copyFields(target, toUpdate);
    }

    @Override
    public void deleteGenera(Collection<Integer> genIDs, ProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            progressMonitor.init(genIDs.size(), "Deleting genera");
        }
        for (Integer genID : genIDs) {
            if (this.taxa.values().stream().anyMatch(taxon -> taxon.getGenus().getGenID() == genID.intValue())) {
                throw new IllegalArgumentException("Cannot delete genera referenced by taxa");
            }
            this.genera.remove(genID);
            if (progressMonitor == null) continue;
            progressMonitor.setValue(progressMonitor.getValue() + 1);
            if (!progressMonitor.isInterrupted()) continue;
            return;
        }
    }

    @Override
    public void deleteTaxa(Collection<Integer> specIDs, ProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            progressMonitor.init(specIDs.size(), "Deleting species");
        }
        for (Integer specID : specIDs) {
            this.taxa.remove(specID);
            if (progressMonitor == null) continue;
            progressMonitor.setValue(progressMonitor.getValue() + 1);
            if (!progressMonitor.isInterrupted()) continue;
            return;
        }
    }

    @Override
    public Set<Integer> getUnusedGenera(Collection<Integer> genIDs) {
        HashSet<Integer> unusedGenera = new HashSet<Integer>();
        for (Integer genID : genIDs) {
            if (this.taxa.values().stream().anyMatch(taxon -> taxon.getGenus().getGenID() == genID.intValue())) continue;
            unusedGenera.add(genID);
        }
        return unusedGenera;
    }

    @Override
    public int getTaxonCountForGenus(int genID) {
        return (int)this.taxa.values().stream().filter(taxon -> taxon.getGenus().getGenID() == genID).count();
    }
}

