/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.user;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.validation.Ident;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.Validatable;
import java.awt.Color;
import java.util.Objects;

@Validatable
public class User
implements Comparable<User> {
    private final int userID;
    @NotEmptyString
    @LimitedLengthString
    private String abr = "";
    @LimitedLengthString
    private String name = "";
    private Discipline discipline = Discipline.MICRO;
    private Color colour = Color.BLACK;

    public User() {
        this.userID = 0;
    }

    public User(int userID) {
        this.userID = userID;
    }

    public User(int userID, String abr) {
        this.userID = userID;
        this.setAbr(abr);
    }

    @Ident
    public int getUserID() {
        return this.userID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNullElse(name, "").trim();
    }

    public String getAbr() {
        return this.abr;
    }

    public void setAbr(String abr) {
        this.abr = Objects.requireNonNullElse(abr, "").trim().toUpperCase();
        this.abr = this.abr.replaceAll("[^A-Z1-9/\\-_]", "");
    }

    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = Objects.requireNonNullElse(discipline, this.discipline);
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        this.colour = Objects.requireNonNullElse(colour, Color.BLACK);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.userID == user.userID;
    }

    public int hashCode() {
        return Objects.hash(this.userID);
    }

    public static User copy(User source) {
        User target = new User(source.getUserID());
        User.copyFields(target, source);
        return target;
    }

    public static void copyFields(User target, User source) {
        target.setName(source.getName());
        target.setAbr(source.getAbr());
        target.setDiscipline(source.getDiscipline());
        target.setColour(source.getColour());
    }

    @Override
    public int compareTo(User o) {
        return User.compare(this, o);
    }

    public static int compare(User o1, User o2) {
        if (o1 != null && o2 != null) {
            return o1.getAbr().compareTo(o2.getAbr());
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        return -1;
    }
}

