/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.user;

import com.stratadata.model3.user.User;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.validation.SbugsValidator;
import com.stratadata.model3.validation.ValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class UserServiceImpl
implements UserService {
    private final TreeMap<Integer, User> users = new TreeMap();

    @Override
    public Optional<User> findUser(int userID) {
        return Optional.ofNullable(this.users.get(userID));
    }

    @Override
    public List<User> getAllUsers() {
        ArrayList<User> list = new ArrayList<User>(this.users.values());
        Collections.sort(list);
        return list;
    }

    @Override
    public User addUser(User user) {
        SbugsValidator validator = SbugsValidator.validate(user, SbugsValidator.ValidationStrategy.IGNORE_ID);
        if (!validator.isValid()) {
            throw new ValidationException(validator);
        }
        if (this.findUserByAbr(user.getAbr()).isPresent()) {
            throw new IllegalArgumentException("A user with this abbreviation already exists");
        }
        if (user.getUserID() > 0) {
            if (this.findUser(user.getUserID()).isPresent()) {
                throw new IllegalArgumentException("This user already exists");
            }
        } else {
            int userID = this.users.keySet().stream().max(Integer::compareTo).orElse(0) + 1;
            User userWithID = new User(userID);
            User.copyFields(userWithID, user);
            user = userWithID;
        }
        this.users.put(user.getUserID(), user);
        return user;
    }
}

