/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.validation;

import com.stratadata.model3.validation.ConstrainedNumber;
import com.stratadata.model3.validation.FieldLengthProperties;
import com.stratadata.model3.validation.Ident;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.NotNull;
import com.stratadata.model3.validation.Validatable;
import com.stratadata.model3.validation.Validation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SbugsValidator {
    private final Object o;
    private final ValidationStrategy strategy;
    private final List<String> messages = new ArrayList<String>();

    public static SbugsValidator validate(Object o, ValidationStrategy strategy) {
        SbugsValidator validator = new SbugsValidator(o, strategy);
        validator.validateObject(o);
        return validator;
    }

    public static SbugsValidator validate(Object o) {
        SbugsValidator validator = new SbugsValidator(o, ValidationStrategy.DEFAULT);
        validator.validateObject(o);
        return validator;
    }

    private SbugsValidator(Object o, ValidationStrategy strategy) {
        this.o = o;
        this.strategy = strategy;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public boolean isValid() {
        return this.messages.isEmpty();
    }

    private void validateObject(Object o) {
        Class<?> clazz = o.getClass();
        if (!clazz.isAnnotationPresent(Validatable.class)) {
            return;
        }
        try {
            boolean idFound = false;
            for (Method method : clazz.getDeclaredMethods()) {
                if (this.strategy != ValidationStrategy.IGNORE_ID && method.isAnnotationPresent(Ident.class)) {
                    int idValue = (Integer)method.invoke(o, new Object[0]);
                    if (idValue < 1) {
                        this.messages.add(clazz.getName() + " has invalid id: " + idValue);
                    }
                    idFound = true;
                    continue;
                }
                if (!idFound) {
                    // empty if block
                }
                if (!method.isAnnotationPresent(Validation.class)) continue;
                this.messages.addAll((List)method.invoke(o, new Object[0]));
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                ((Field)accessibleObject).setAccessible(true);
                if (((Field)accessibleObject).getType().isAnnotationPresent(Validatable.class)) {
                    Object fieldValue = ((Field)accessibleObject).get(o);
                    if (fieldValue == null) {
                        this.messages.add(((Field)accessibleObject).getName() + " must not be null");
                    } else {
                        this.validateObject(fieldValue);
                    }
                }
                this.checkForLimitedLengthString((Field)accessibleObject, o);
                this.checkForNotEmptyString((Field)accessibleObject, o);
                this.checkForNotNull((Field)accessibleObject, o);
                this.checkForConstrainedNumber((Field)accessibleObject, o);
                ((Field)accessibleObject).setAccessible(false);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.messages.add(e.getMessage());
        }
    }

    private void checkForLimitedLengthString(Field field, Object o) throws IllegalAccessException {
        if (field.isAnnotationPresent(LimitedLengthString.class)) {
            int maxLength;
            String value = (String)field.get(o);
            if (value == null) {
                value = "";
            }
            if ((maxLength = FieldLengthProperties.getFieldLength(field).orElse(field.getAnnotation(LimitedLengthString.class).maxLength()).intValue()) == 0) {
                return;
            }
            if (value.length() > maxLength) {
                this.messages.add(this.getFieldName(field) + " must not exceed the character limit of " + maxLength);
            }
        }
    }

    private void checkForNotEmptyString(Field field, Object o) throws IllegalAccessException {
        String value;
        if (field.isAnnotationPresent(NotEmptyString.class) && StringUtils.isBlank((CharSequence)(value = (String)field.get(o)))) {
            this.messages.add(this.getFieldName(field) + " must not be empty");
        }
    }

    private void checkForNotNull(Field field, Object o) throws IllegalAccessException {
        Object value;
        if (field.isAnnotationPresent(NotNull.class) && (value = field.get(o)) == null) {
            this.messages.add(this.getFieldName(field) + " must not be null");
        }
    }

    private void checkForConstrainedNumber(Field field, Object o) throws IllegalAccessException {
        if (field.isAnnotationPresent(ConstrainedNumber.class)) {
            Object value = field.get(o);
            if (value == null) {
                if (!field.getAnnotation(ConstrainedNumber.class).nullable()) {
                    this.messages.add(this.getFieldName(field) + " must not be null");
                }
                return;
            }
            Double number = (Double)value;
            double minVal = field.getAnnotation(ConstrainedNumber.class).minVal();
            if (number < minVal) {
                this.messages.add(this.getFieldName(field) + " must not be less than " + minVal);
            }
            double maxVal = field.getAnnotation(ConstrainedNumber.class).maxVal();
            if (number > maxVal) {
                this.messages.add(this.getFieldName(field) + " must not be more than " + maxVal);
            }
        }
    }

    private String getFieldName(Field field) {
        String s;
        if (field.isAnnotationPresent(NotEmptyString.class) && !(s = field.getAnnotation(NotEmptyString.class).fieldName()).isEmpty()) {
            return s;
        }
        if (field.isAnnotationPresent(LimitedLengthString.class) && !(s = field.getAnnotation(LimitedLengthString.class).fieldName()).isEmpty()) {
            return s;
        }
        if (field.isAnnotationPresent(ConstrainedNumber.class) && !(s = field.getAnnotation(ConstrainedNumber.class).fieldName()).isEmpty()) {
            return s;
        }
        return field.getName();
    }

    public static enum ValidationStrategy {
        DEFAULT,
        IGNORE_ID;

    }
}

