/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well;

import com.stratadata.model3.well.WellHeader;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SidetrackSorter {
    private final Function<Integer, WellHeader> wells;

    public SidetrackSorter(Function<Integer, WellHeader> wells) {
        this.wells = wells;
    }

    private WellHeader getRootHeader(WellHeader h) {
        WellHeader root = h;
        while (root.getParentWellID() != null) {
            root = this.wells.apply(root.getParentWellID());
        }
        return root;
    }

    private double getKickoffFromRoot(WellHeader h) {
        WellHeader root = this.getRootHeader(h);
        while (h.getParentWellID() != null && h.getParentWellID().intValue() != root.getWellID()) {
            h = this.wells.apply(h.getParentWellID());
        }
        return h.getKickOff() != null ? h.getKickOff() : 0.0;
    }

    private double getKickoff(WellHeader h) {
        return h.getKickOff() != null ? h.getKickOff() : 0.0;
    }

    public Stream<WellHeader> sort(Stream<WellHeader> items) {
        Map<WellHeader, TreeSet> collection = items.collect(Collectors.groupingBy(h -> this.getRootHeader((WellHeader)h), Collectors.toCollection(() -> new TreeSet<WellHeader>(Comparator.comparing(h -> Objects.requireNonNullElse(h.getParentWellID(), 0)).thenComparing(h -> this.getKickoffFromRoot((WellHeader)h)).thenComparing(h -> this.getKickoff((WellHeader)h))))));
        TreeMap<WellHeader, TreeSet> sorted = new TreeMap<WellHeader, TreeSet>(WellHeader::compareTo);
        sorted.putAll(collection);
        return sorted.sequencedValues().stream().flatMap(col -> col.stream());
    }
}

