/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis;

import org.apache.commons.lang3.StringUtils;

public enum Situation {
    INSITU("In-situ", 'I', "", false),
    TR("Transported", 'T', "Tr", true),
    RW("Reworked", 'R', "Rw", true),
    CV("Caved", 'C', "Cv", true),
    CN("Contamination", 'N', "Cn", true);

    private final char dbChar;
    private final String descr;
    private final String abr;
    private final boolean isQualified;

    private Situation(String descr, char dbChar, String abr, boolean isQualified) {
        this.descr = descr;
        this.dbChar = dbChar;
        this.abr = abr;
        this.isQualified = isQualified;
    }

    public String toString() {
        return this.descr;
    }

    public char toChar() {
        return this.dbChar;
    }

    public String toCharString() {
        return "'" + this.dbChar + "'";
    }

    public String getAbr() {
        return this.abr;
    }

    public boolean isQualified() {
        return this.isQualified;
    }

    public String getDescr() {
        return this.descr;
    }

    public static Situation parse(String situation) {
        if (StringUtils.isBlank((CharSequence)situation)) {
            return INSITU;
        }
        if (situation.equalsIgnoreCase(Situation.CN.descr)) {
            return CN;
        }
        return Situation.parse(situation.charAt(0));
    }

    public static Situation parse(char situation) {
        return switch (situation) {
            default -> INSITU;
            case 'T' -> TR;
            case 'R' -> RW;
            case 'C' -> CV;
            case 'N' -> CN;
        };
    }
}

