/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis;

import com.stratadata.model3.well.analysis.SpeciesType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface SpeciesTypeService {
    public static final String SPEC_TYPE_DEFAULT = "<no sub-type>";

    public Optional<SpeciesType> getSpeciesType(int var1);

    public Optional<SpeciesType> findSpeciesType(String var1);

    public SpeciesType getAddSpeciesType(String var1);

    public void addSpeciesType(SpeciesType var1);

    public List<SpeciesType> getAllSpeciesTypes();

    public SpeciesType updateSpeciesTypeDescription(int var1, String var2);

    public void deleteSpeciesType(SpeciesType var1);

    default public void addListener(Listener l) {
    }

    default public List<Listener> getListeners() {
        return Collections.emptyList();
    }

    default public SpeciesType getAddLegacySpeciesType(char form, char growth, String specType) {
        String[] types = new String[]{StringUtils.trimToNull((String)SpeciesTypeService.getSpecTypeStringV18(form, growth)), StringUtils.trimToNull((String)specType)};
        String speciesType = Arrays.stream(types).filter(Objects::nonNull).collect(Collectors.joining("/"));
        return this.getAddSpeciesType(speciesType);
    }

    public static String getSpecTypeStringV18(char form, char growth) {
        ArrayList<String> strings = new ArrayList<String>();
        if (form != 'C' || growth != 'A') {
            switch (form) {
                case 'E': {
                    strings.add("Entire");
                    break;
                }
                case 'C': {
                    strings.add("Component");
                    break;
                }
                case 'B': {
                    strings.add("Broken");
                    break;
                }
                case 'F': {
                    strings.add("Fragment");
                }
            }
            switch (growth) {
                case 'A': {
                    strings.add("Adult");
                    break;
                }
                case 'J': {
                    strings.add("Juvenile");
                }
            }
        }
        return StringUtils.join(strings, (String)"/");
    }

    public static interface Listener {
        public void speciesTypesUpdated();
    }
}

