/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis;

import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.SpeciesTypeService;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class SpeciesTypeServiceImpl
implements SpeciesTypeService {
    private HashMap<Integer, String> specTypes = new HashMap();

    public SpeciesTypeServiceImpl() {
        this.specTypes.put(0, "<no sub-type>");
    }

    @Override
    public Optional<SpeciesType> getSpeciesType(int specTypeID) {
        String s = this.specTypes.get(specTypeID);
        if (s == null) {
            return Optional.empty();
        }
        return Optional.of(new SpeciesType(specTypeID, s));
    }

    @Override
    public Optional<SpeciesType> findSpeciesType(String specType) {
        if (specType == null || specType.isBlank()) {
            return Optional.of(new SpeciesType(0, "<no sub-type>"));
        }
        return this.specTypes.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getValue()).equalsIgnoreCase(specType)).findFirst().map(mapEntry -> new SpeciesType((Integer)mapEntry.getKey(), (String)mapEntry.getValue()));
    }

    @Override
    public SpeciesType getAddSpeciesType(String specType) {
        Integer specTypeID = this.findSpeciesType(specType).map(SpeciesType::specTypeID).orElse(null);
        if (specTypeID == null) {
            specTypeID = this.specTypes.keySet().stream().reduce(Integer::max).orElse(0) + 1;
            this.specTypes.put(specTypeID, specType);
        }
        return new SpeciesType(specTypeID, this.specTypes.get(specTypeID));
    }

    @Override
    public void addSpeciesType(SpeciesType speciesType) {
        if (speciesType.specTypeID() < 0) {
            throw new IllegalArgumentException("Invalid species type ID: " + speciesType.specTypeID());
        }
        if (this.specTypes.get(speciesType.specTypeID()) != null) {
            return;
        }
        this.specTypes.put(speciesType.specTypeID(), speciesType.description());
    }

    @Override
    public List<SpeciesType> getAllSpeciesTypes() {
        return this.specTypes.entrySet().stream().map(e -> new SpeciesType((Integer)e.getKey(), (String)e.getValue())).toList();
    }

    @Override
    public SpeciesType updateSpeciesTypeDescription(int specTypeID, String newDescription) {
        if (!this.specTypes.containsKey(specTypeID)) {
            throw new IllegalArgumentException("No species type to update");
        }
        this.specTypes.put(specTypeID, newDescription);
        return new SpeciesType(specTypeID, newDescription);
    }

    @Override
    public void deleteSpeciesType(SpeciesType speciesType) {
        if (!this.specTypes.containsKey(speciesType.specTypeID())) {
            throw new IllegalArgumentException("No species type to delete");
        }
        if (speciesType.specTypeID() == 0) {
            throw new IllegalArgumentException("Can't delete the default species type");
        }
        this.specTypes.remove(speciesType.specTypeID());
    }
}

