/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.curve;

import com.stratadata.model3.well.curve.Curve;
import com.stratadata.model3.well.curve.WellCurveService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class CombinedWellCurveService
implements WellCurveService {
    private final List<WellCurveService> services;
    private final int wellID;

    public CombinedWellCurveService(WellCurveService ... services) {
        if (services.length == 0) {
            throw new IllegalArgumentException("You must add at least one CurveService");
        }
        this.wellID = services[0].getWellID();
        if (!Arrays.stream(services).allMatch(s -> s.getWellID() == this.wellID)) {
            throw new IllegalArgumentException("All services must be for the same well");
        }
        this.services = Arrays.stream(services).toList();
    }

    @Override
    public int getWellID() {
        return this.wellID;
    }

    @Override
    public int getCurveCount() {
        return this.services.stream().mapToInt(WellCurveService::getCurveCount).sum();
    }

    @Override
    public List<Curve> getCurves(boolean activeOnly) {
        ArrayList<Curve> allCurves = new ArrayList<Curve>();
        for (WellCurveService s : this.services) {
            allCurves.addAll(s.getCurves(activeOnly));
        }
        return allCurves;
    }

    @Override
    public void addListener(WellCurveService.Listener l) {
        this.services.forEach(service -> service.addListener(l));
    }

    @Override
    public void deleteListener(WellCurveService.Listener l) {
        this.services.forEach(service -> service.deleteListener(l));
    }

    @Override
    public Stream<WellCurveService.Listener> getListeners() {
        return this.services.stream().flatMap(wellCurveService -> wellCurveService.getListeners());
    }

    @Override
    public void setCurveActive(int curveID, boolean active) {
        if (this.services.size() > 1) {
            throw new IllegalStateException();
        }
        WellCurveService.super.setCurveActive(curveID, active);
    }
}

