/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.curve;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Curve {
    private final int curveID;
    private final List<CurveValue> trace;
    private final String abr;
    private final String mnem;
    private String fileName;
    private String comments;
    private final AuditImpl audit;
    private Double top;
    private Double base;
    private boolean active = true;

    public Curve(int curveID, List<CurveValue> trace, String abr, String mnem, String fileName, String comments, AuditImpl audit) {
        this.trace = trace;
        this.curveID = curveID;
        this.abr = abr;
        this.mnem = mnem;
        this.fileName = fileName;
        this.audit = audit;
        this.comments = comments;
        this.initTopAndBaseValues();
    }

    private void initTopAndBaseValues() {
        if (!this.trace.isEmpty()) {
            this.top = this.trace.stream().mapToDouble(CurveValue::depth).min().orElse(0.0);
            this.base = this.trace.stream().mapToDouble(CurveValue::depth).max().orElse(0.0);
        } else {
            this.top = null;
            this.base = null;
        }
    }

    public static Curve copyOf(Curve c, int curveID, AuditImpl audit, String abr) {
        LinkedList<CurveValue> trace = new LinkedList<CurveValue>();
        for (CurveValue value : c.trace) {
            trace.add(new CurveValue(value.depth, value.value));
        }
        return new Curve(curveID, trace, abr, c.mnem, c.fileName, c.comments, audit);
    }

    public static Curve copyWithFilterValue(Curve c) {
        LinkedList<CurveValue> trace = new LinkedList<CurveValue>();
        double FILTER_VALUE = 0.15;
        Double lastDepth = null;
        for (CurveValue value : c.trace) {
            if (lastDepth != null && !(value.depth - lastDepth > 0.15)) continue;
            trace.add(new CurveValue(value.depth, value.value));
            lastDepth = value.depth;
        }
        return new Curve(c.curveID, trace, c.abr, c.mnem, c.fileName, c.comments, c.audit);
    }

    public Audit getAudit() {
        return this.audit;
    }

    public List<CurveValue> getTrace() {
        return Collections.unmodifiableList(this.trace);
    }

    public int getSize() {
        return this.trace.size();
    }

    public void deleteValues(Collection<CurveValue> toDelete) {
        LinkedList<CurveValue> deleteFromTrace = new LinkedList<CurveValue>();
        block0: for (CurveValue v : toDelete) {
            for (CurveValue tv : this.trace) {
                if (!(Math.abs(tv.depth - v.depth) < 0.01)) continue;
                deleteFromTrace.add(tv);
                continue block0;
            }
        }
        this.trace.removeAll(deleteFromTrace);
        this.initTopAndBaseValues();
    }

    public Double getTopDepth() {
        return this.top;
    }

    public Double getBaseDepth() {
        return this.base;
    }

    public String getAbr() {
        return this.abr;
    }

    public String getMnem() {
        return this.mnem;
    }

    public String getFilename() {
        return this.fileName;
    }

    public void setFilename(String filename) {
        this.fileName = StringUtils.trimToNull((String)filename);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = StringUtils.trimToNull((String)comments);
    }

    public int getID() {
        return this.curveID;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getSortEntry(String abr) {
        String topString = "" + (this.getTopDepth() != null ? (int)(this.getTopDepth() * 1000.0) : 0);
        while (topString.length() < 7) {
            topString = " " + topString;
        }
        String baseString = "" + (this.getBaseDepth() != null ? (int)(this.getBaseDepth() * 1000.0) : 0);
        while (baseString.length() < 7) {
            baseString = " " + baseString;
        }
        return abr + topString + "-" + baseString;
    }

    public record CurveValue(double depth, double value) {
    }
}

