/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.sample;

import com.stratadata.model3.SystemPreferences;
import com.stratadata.model3.well.sample.SampleProperties;
import java.util.Comparator;

public class SampleComparator
implements Comparator<SampleProperties> {
    @Override
    public int compare(SampleProperties s1, SampleProperties s2) {
        return SampleComparator.compareSamples(s1, s2);
    }

    public static int compareSamples(SampleProperties s1, SampleProperties s2) {
        int secondary2;
        int preferred2;
        if (s1 == s2) {
            return 0;
        }
        boolean useTops = SystemPreferences.getInstance().useSampleTops();
        int preferred1 = useTops ? SampleComparator.getIntegerTopDepthForComparison(s1) : SampleComparator.getIntegerBaseDepthForComparison(s1);
        int n = preferred2 = useTops ? SampleComparator.getIntegerTopDepthForComparison(s2) : SampleComparator.getIntegerBaseDepthForComparison(s2);
        if (preferred1 != preferred2) {
            return Integer.compare(preferred1, preferred2);
        }
        int secondary1 = useTops ? SampleComparator.getIntegerBaseDepthForComparison(s1) : SampleComparator.getIntegerTopDepthForComparison(s1);
        int n2 = secondary2 = useTops ? SampleComparator.getIntegerBaseDepthForComparison(s2) : SampleComparator.getIntegerTopDepthForComparison(s2);
        if (secondary1 != secondary2) {
            return Integer.compare(secondary1, secondary2);
        }
        if (s1.getType() != s2.getType()) {
            return s1.getType().name().compareTo(s2.getType().name());
        }
        return s1.getSampID() - s2.getSampID();
    }

    private static int getIntegerTopDepthForComparison(SampleProperties s) {
        return SampleComparator.getRoundedDepth(s.getTopDepth() != null ? s.getTopDepth() : s.getBaseDepth());
    }

    private static int getIntegerBaseDepthForComparison(SampleProperties s) {
        return SampleComparator.getRoundedDepth(s.getBaseDepth() != null ? s.getBaseDepth() : s.getTopDepth());
    }

    private static int getRoundedDepth(double depth) {
        return (int)Math.round(depth * 1000.0);
    }
}

