/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.sample;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.SystemPreferences;
import com.stratadata.model3.well.sample.DepthCorrectionService;
import com.stratadata.model3.well.sample.Sample;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.model3.well.sample.WellSampleService;
import java.util.Optional;
import java.util.TreeSet;

public class SampleList
implements WellSampleService {
    private final long wellID;
    private final TreeSet<Sample> samples = new TreeSet();

    public SampleList(long wellID) {
        this.wellID = wellID;
    }

    public void addSample(Sample sample) {
        if (sample.getWellID() != this.wellID) {
            throw new IllegalArgumentException();
        }
        this.samples.add(sample);
    }

    @Override
    public Optional<Sample> findSample(double depth, SampleType type) {
        boolean useSampleTops = SystemPreferences.getInstance().useSampleTops();
        return this.samples.stream().filter(sample -> type == null || sample.getType() == type).filter(sample -> useSampleTops && sample.getTopDepth() != null && Math.abs(depth - sample.getTopDepth()) < 0.0029 || !useSampleTops && sample.getBaseDepth() != null && Math.abs(depth - sample.getBaseDepth()) < 0.0029).findFirst();
    }

    @Override
    public Optional<Sample> findSampleNearestBelow(double depth, Discipline withAnalysisInDiscipline, DepthCorrectionService depthCorrection) {
        for (Sample sample : this.samples) {
            if (!(depth <= depthCorrection.getDepth(sample))) continue;
            return Optional.of(sample);
        }
        return Optional.empty();
    }
}

