/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.sample;

import com.stratadata.model3.SystemPreferences;
import com.stratadata.model3.well.sample.SampleProperties;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import java.util.List;

public class SampleStringFactory {
    private static final boolean SHOW_UNITS_DEFAULT = Boolean.TRUE;
    private static final boolean SHOW_LABEL_DEFAULT = Boolean.TRUE;
    private static final boolean SHOW_TYPE_DEFAULT = Boolean.TRUE;
    private static final boolean SHOW_RANGE_DEFAULT = Boolean.TRUE;
    private static final boolean SHOW_SHORT_TYPE = Boolean.FALSE;

    public static String toString(SampleProperties sample, DepthUnits units) {
        return SampleStringFactory.toString(sample, units, SHOW_UNITS_DEFAULT, SHOW_LABEL_DEFAULT);
    }

    public static String toString(SampleProperties sample, DepthUnits units, boolean showUnits, boolean showLabel) {
        return SampleStringFactory.toString(sample, units, showUnits, showLabel, SHOW_TYPE_DEFAULT, SHOW_RANGE_DEFAULT, null, null, SHOW_SHORT_TYPE);
    }

    public static String toString(SampleProperties sample, DepthUnits units, boolean showUnits, boolean showLabel, boolean showType, boolean showRange, Double correctedDepthTop, Double correctedDepthBase) {
        return SampleStringFactory.toString(sample, units, showUnits, showLabel, showType, showRange, correctedDepthTop, correctedDepthBase, SHOW_SHORT_TYPE);
    }

    public static String toString(SampleProperties sample, DepthUnits units, boolean showUnits, boolean showLabel, boolean showType, boolean showRange, Double correctedDepthTop, Double correctedDepthBase, boolean showShortType) {
        boolean appendType;
        double displayTop;
        Double top = sample.getTopDepth();
        Double base = sample.getBaseDepth();
        if (correctedDepthTop != null) {
            displayTop = DepthUtils.convFromM(correctedDepthTop, units, sample.getSectionType());
        } else {
            double d = displayTop = top != null ? DepthUtils.convFromM(top, units, sample.getSectionType()) : 0.0;
        }
        double displayBase = correctedDepthBase != null ? DepthUtils.convFromM(correctedDepthBase, units, sample.getSectionType()) : (base != null ? DepthUtils.convFromM(base, units, sample.getSectionType()) : 0.0);
        displayTop = sample.getType().getRoundedDepth(displayTop);
        displayBase = sample.getType().getRoundedDepth(displayBase);
        StringBuilder s = new StringBuilder();
        if (Math.abs(displayTop - displayBase) > 0.0029 && showRange) {
            if (sample.getTopDepth() != null) {
                s.append(DepthUtils.depthString(displayTop, sample.getType().getPrecision()));
                if (sample.getBaseDepth() != null) {
                    s.append(" - ");
                }
            }
            if (sample.getBaseDepth() != null) {
                s.append(DepthUtils.depthString(displayBase, sample.getType().getPrecision()).trim());
            }
        } else if (!SystemPreferences.getInstance().useSampleTops() && sample.getBaseDepth() != null) {
            s.append(DepthUtils.depthString(displayBase, sample.getType().getPrecision()));
        } else {
            s.append(DepthUtils.depthString(displayTop, sample.getType().getPrecision()));
        }
        if (showUnits) {
            s.append(units.getSymbol());
        }
        SampleType type = sample.getType();
        List<SampleType> commonTypes = List.of(SampleType.CU, SampleType.OC);
        boolean bl = appendType = showType && (!SystemPreferences.getInstance().hideCommonSampleTypes() || !commonTypes.contains((Object)type));
        if (appendType) {
            s.append(' ').append(showShortType ? type.getShortName() : type.name());
        }
        String textLabel = sample.getLabel();
        if (showLabel && textLabel != null && !textLabel.trim().isEmpty()) {
            s.append(' ').append(textLabel);
        }
        return s.toString();
    }
}

