/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.wellinterp;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.event.DictionaryEvent;
import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.well.sample.Sample;
import com.stratadata.model3.well.sample.SampleStringFactory;
import com.stratadata.util.depth.DepthUnits;
import java.util.Objects;
import java.util.Optional;

public class WellEvent
implements Audited {
    private Sample sample;
    private EventType type;
    private DictionaryEvent dictEvent;
    private Confidence confidence;
    private String comments;
    private String qualifier;
    private Discipline discipline;
    private Audit audit = new AuditImpl();

    public String toString(boolean qual, boolean depth, DepthUnits units, boolean confidence, boolean abr, boolean useNameWithAbr) {
        StringBuilder sb = new StringBuilder();
        if (depth) {
            sb.append(SampleStringFactory.toString(this.getSample(), units)).append(" ");
        }
        if (qual) {
            sb.append(this.getQualifier().map(p -> p + " ").orElse(""));
        }
        sb.append(this.dictEvent.toString(this.getType(), EventContext.WELL, abr, useNameWithAbr));
        if (confidence && this.getConfidence() != Confidence.CONFIDENT) {
            sb.append(" (").append((Object)this.getConfidence()).append(")");
        }
        return sb.toString();
    }

    public Sample getSample() {
        return this.sample;
    }

    public void setSample(Sample sample) {
        this.sample = sample;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        Objects.requireNonNull(type, "Event type cannot be null");
        this.type = type;
    }

    public DictionaryEvent getDictEvent() {
        return this.dictEvent;
    }

    public void setDictEvent(DictionaryEvent dictEvent) {
        this.dictEvent = dictEvent;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Optional<String> getQualifier() {
        return Optional.ofNullable(this.qualifier);
    }

    public void setQualifier(String qualifier) {
        if (qualifier != null && (qualifier = qualifier.trim()).isEmpty()) {
            qualifier = null;
        }
        this.qualifier = qualifier;
    }

    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    public void setAudit(Audit audit) {
        if (audit == null) {
            this.audit = new AuditImpl();
            return;
        }
        this.audit = audit;
    }
}

