/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.shadedrelief.ShadedReliefAlgorithm;
import it.geosolutions.jaiext.shadedrelief.ShadedReliefDescriptor;
import it.geosolutions.jaiext.shadedrelief.ShadedReliefRIF;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.measure.Unit;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ROI;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.RenderedOp;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.i18n.ErrorKeys;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapNode;
import org.geotools.renderer.lite.gridcoverage2d.Compositing;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import si.uom.SI;

class ShadedReliefNode
extends StyleVisitorCoverageProcessingNodeAdapter
implements StyleVisitor,
CoverageProcessingNode {
    private boolean brightnessOnly = false;
    private double reliefFactor = Double.NaN;

    public double getReliefFactor() {
        return this.reliefFactor;
    }

    @Override
    public InternationalString getName() {
        return new SimpleInternationalString("Shaded Relief");
    }

    @Override
    public void visit(ShadedRelief sr) {
        Number number;
        if (sr == null) {
            return;
        }
        this.brightnessOnly = sr.isBrightnessOnly();
        Expression rFactor = sr.getReliefFactor();
        if (rFactor != null && (number = (Number)rFactor.evaluate(null, Double.class)) != null) {
            this.reliefFactor = number.doubleValue();
            if (this.reliefFactor < 0.0 || Double.isNaN(this.reliefFactor) || Double.isInfinite(this.reliefFactor)) {
                throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$2, "reliefFactor", number));
            }
        }
    }

    public ShadedReliefNode() {
        this((Hints)null);
    }

    public ShadedReliefNode(Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ShadedReliefNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies ShadedRelief following SLD 1.0 spec."));
    }

    protected GridCoverage2D execute() {
        Hints hints = this.getHints();
        List<CoverageProcessingNode> sources = this.getSources();
        if (sources != null && !sources.isEmpty()) {
            GridSampleDimension[] sd;
            CoverageProcessingNode nodeSource = this.getSource(0);
            CoverageProcessingNode colorMapNode = null;
            if (nodeSource instanceof ColorMapNode && ((ColorMapNode)nodeSource).getType() != ColorMapNode.TYPE_NONE) {
                colorMapNode = nodeSource;
                nodeSource = nodeSource.getSource(0);
            }
            GridCoverage2D source = (GridCoverage2D)nodeSource.getOutput();
            GridCoverageRendererUtilities.ensureSourceNotNull(source, this.getName().toString());
            RenderedImage sourceImage = source.getRenderedImage();
            ROI roi = CoverageUtilities.getROIProperty((GridCoverage2D)source);
            NoDataContainer noDataContainer = CoverageUtilities.getNoDataProperty((GridCoverage2D)source);
            Range nodata = noDataContainer != null ? noDataContainer.getAsRange() : null;
            ImageWorker worker = new ImageWorker(sourceImage).setROI(roi).setNoData(nodata).setRenderingHints((RenderingHints)hints).forceComponentColorModel();
            int numbands = worker.getNumBands();
            if (numbands > 1) {
                throw new IllegalArgumentException("ShadedRelief can only be applied to single band images");
            }
            this.performShadedRelief(worker, source, hints);
            int numSourceBands = source.getNumSampleDimensions();
            RenderedImage finalImage = worker.getRenderedImage();
            int numActualBands = finalImage.getSampleModel().getNumBands();
            GridCoverageFactory factory = this.getCoverageFactory();
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (source.getProperties() != null) {
                props.putAll(source.getProperties());
            }
            if (worker.getROI() != null) {
                props.put("GC_ROI", worker.getROI());
            }
            if (numActualBands == numSourceBands) {
                sd = source.getSampleDimensions();
            } else {
                sd = new GridSampleDimension[numActualBands];
                for (int i = 0; i < numActualBands; ++i) {
                    sd[i] = source.getSampleDimension(0);
                }
            }
            GridCoverage2D output = factory.create((CharSequence)("sr_coverage" + source.getName()), finalImage, source.getGridGeometry(), sd, new GridCoverage[]{source}, props);
            if (colorMapNode != null) {
                GridCoverage2D mapCoverage = (GridCoverage2D)colorMapNode.getOutput();
                if (!this.brightnessOnly) {
                    props.put("Compositing", new Compositing(finalImage));
                    output = factory.create((CharSequence)("sr_coverage" + source.getName().toString()), mapCoverage.getRenderedImage(), source.getGridGeometry(), output.getSampleDimensions(), new GridCoverage[]{output}, props);
                }
            }
            return output;
        }
        String arg0 = this.getName().toString();
        throw new IllegalStateException(MessageFormat.format(ErrorKeys.SOURCE_CANT_BE_NULL_$1, arg0));
    }

    private RenderedImage performShadedRelief(ImageWorker intensityWorker, GridCoverage2D source, Hints hints) {
        RenderedImage ri = source.getRenderedImage();
        MathTransform g2w = source.getGridGeometry().getGridToCRS();
        AffineTransform af = (AffineTransform)g2w;
        CoordinateReferenceSystem crs = source.getCoordinateReferenceSystem();
        Unit unit = crs.getCoordinateSystem().getAxis(0).getUnit();
        boolean isMeter = unit.isCompatible(SI.METRE);
        double resX = af.getScaleX();
        double resY = af.getScaleY();
        double[] destNoData = intensityWorker.getDestinationNoData();
        double destinationNoData = destNoData != null ? destNoData[0] : 0.0;
        RenderedOp finalImage = ShadedReliefDescriptor.create((RenderedImage)ri, (ROI)intensityWorker.getROI(), (Range)intensityWorker.getNoData(), (double)destinationNoData, (double)resX, (double)resY, (double)this.reliefFactor, (double)(isMeter ? 1.0 : 111120.0), (double)45.0, (double)315.0, (ShadedReliefAlgorithm)ShadedReliefAlgorithm.ZEVENBERGEN_THORNE_COMBINED, (RenderingHints)hints);
        intensityWorker.setImage((RenderedImage)finalImage);
        return finalImage;
    }

    static {
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        ShadedReliefDescriptor op = new ShadedReliefDescriptor();
        registry.registerDescriptor((RegistryElementDescriptor)op);
        String descName = op.getName();
        ShadedReliefRIF rif = new ShadedReliefRIF();
        registry.registerFactory("rendered", descName, "org.geotools.gce.processing", (Object)rif);
    }
}

