/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Symbolizer;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;

public class DynamicPolygonStyle2D
extends PolygonStyle2D {
    SimpleFeature feature;
    PolygonSymbolizer ps;

    public DynamicPolygonStyle2D(SimpleFeature f, PolygonSymbolizer sym) {
        this.feature = f;
        this.ps = sym;
    }

    @Override
    public Paint getFill() {
        Fill fill = this.ps.getFill();
        if (fill == null) {
            return null;
        }
        Paint fillPaint = (Paint)fill.getColor().evaluate((Object)this.feature, Color.class);
        Graphic gr = fill.getGraphicFill();
        if (gr != null) {
            SLDStyleFactory fac = new SLDStyleFactory();
            fillPaint = fac.getTexturePaint(gr, this.feature, (Symbolizer)this.ps);
        }
        return fillPaint;
    }

    @Override
    public Composite getFillComposite() {
        Fill fill = this.ps.getFill();
        if (fill == null) {
            return null;
        }
        float opacity = ((Float)fill.getOpacity().evaluate((Object)this.feature, Float.class)).floatValue();
        if (opacity == 1.0f) {
            return null;
        }
        return AlphaComposite.getInstance(3, opacity);
    }
}

