/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ExternalMark;
import org.geotools.renderer.style.FontCache;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.util.ExplicitBoundsShape;

public class TTFMarkFactory
implements MarkFactory {
    private static FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(new AffineTransform(), false, false);
    public static TTFMarkFactory INSTANCE = new TTFMarkFactory();

    @Override
    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        char character;
        String markUrl = (String)symbolUrl.evaluate((Object)feature, String.class);
        if (!markUrl.startsWith("ttf://")) {
            return null;
        }
        if (!markUrl.matches("ttf://.+#.+")) {
            throw new IllegalArgumentException("Mark URL font found, but does not match the required structure font://<fontName>#<charNumber>, e.g., ttf://wingdigs#0x7B. You specified " + markUrl);
        }
        String[] fontElements = markUrl.substring(6).split("#");
        Object code = fontElements[1];
        try {
            if (((String)code).startsWith("U+") || ((String)code).startsWith("\\u")) {
                code = "0x" + ((String)code).substring(2);
            }
            character = (char)Integer.decode((String)code).intValue();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid character specification " + fontElements[1], e);
        }
        String fontFamilyName = fontElements[0];
        return this.getShape(fontFamilyName, character);
    }

    private Shape getShape(String fontFamilyName, char character) {
        char alternative;
        Font font = FontCache.getDefaultInstance().getFont(fontFamilyName);
        if (font == null) {
            throw new IllegalArgumentException("Unknown font " + fontFamilyName);
        }
        if (!font.canDisplay(character) && font.canDisplay(alternative = (char)(0xF000 | character))) {
            character = alternative;
        }
        GlyphVector textGlyphVector = font.createGlyphVector(FONT_RENDER_CONTEXT, new char[]{character});
        Shape s = textGlyphVector.getOutline();
        Rectangle2D bounds = s.getBounds2D();
        AffineTransform tx = new AffineTransform();
        double max = Math.max(bounds.getWidth(), bounds.getHeight());
        tx.scale(1.0 / max, -1.0 / max);
        tx.translate(-bounds.getCenterX(), -bounds.getCenterY());
        ExplicitBoundsShape shape = new ExplicitBoundsShape(tx.createTransformedShape(s));
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    public Shape getShape(ExternalMark mark) {
        String family;
        if (!"ttf".equals(mark.getFormat())) {
            return null;
        }
        String link = mark.getOnlineResource().getLinkage().toString();
        if (!link.startsWith("ttf://")) {
            return null;
        }
        try {
            family = URLDecoder.decode(link.substring(6), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int markIdx = mark.getMarkIndex();
        char character = (char)markIdx;
        return this.getShape(family, character);
    }

    public static void main(String[] args) {
        BufferedImage image = new BufferedImage(300, 300, 6);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setColor(Color.BLACK);
        char c = '\uf041';
        System.out.println((int)c);
        Font font = new Font("Webdings", 0, 60);
        for (int i = 0; i < 65536; ++i) {
            if (!font.canDisplay(i)) continue;
            System.out.println(i + ": " + Long.toHexString(i));
        }
        GlyphVector textGlyphVector = font.createGlyphVector(FONT_RENDER_CONTEXT, new char[0]);
        Shape shape = textGlyphVector.getOutline();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(150, 150);
        g2d.setColor(Color.BLUE);
        g2d.fill(shape);
        g2d.setColor(Color.BLACK);
        g2d.setFont(font);
        g2d.drawString(new String(new char[]{c}), 0, 50);
        g2d.dispose();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(new JLabel(new ImageIcon(image)));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

