/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.util.logging.Logger;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.filter.text.commons.FilterToTextUtil;
import org.geotools.util.logging.Logging;

class FilterToCQL
implements FilterVisitor {
    private static Logger LOGGER = Logging.getLogger(FilterToCQL.class);

    FilterToCQL() {
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return FilterToTextUtil.buildExclude(extraData);
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return FilterToTextUtil.buildInclude(extraData);
    }

    public Object visit(And filter, Object extraData) {
        return FilterToTextUtil.buildBinaryLogicalOperator("AND", this, (BinaryLogicOperator)filter, extraData);
    }

    public Object visit(Id filter, Object extraData) {
        throw new IllegalStateException("Cannot encode an Id as legal CQL");
    }

    public Object visit(Not filter, Object extraData) {
        LOGGER.finer("exporting Not filter");
        return FilterToTextUtil.buildNot(this, filter, extraData);
    }

    public Object visit(Or filter, Object extraData) {
        LOGGER.finer("exporting Or filter");
        return FilterToTextUtil.buildBinaryLogicalOperator("OR", this, (BinaryLogicOperator)filter, extraData);
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        return FilterToTextUtil.buildBetween(filter, extraData);
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, "=");
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, "<>");
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, ">");
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, ">=");
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, "<");
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, "<=");
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression());
        return FilterToTextUtil.buildIsLike(filter, extraData);
    }

    private void checkLeftExpressionIsProperty(Expression expr) {
        if (!(expr instanceof PropertyName)) {
            throw new RuntimeException("CQL requires a PropertyName");
        }
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return FilterToTextUtil.buildIsNull(filter, extraData);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("isNil not supported");
    }

    public Object visit(BBOX filter, Object extraData) {
        return FilterToTextUtil.buildBBOX(filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildDistanceBufferOperation("BEYOND", (DistanceBufferOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("CONTAINS", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("CROSSES", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("DISJOINT", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildDWithin(filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("EQUALS", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("INTERSECTS", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("OVERLAPS", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("TOUCHES", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("WITHIN", (BinarySpatialOperator)filter, extraData);
    }

    public Object visitNullFilter(Object extraData) {
        throw new NullPointerException("Cannot encode null as a Filter");
    }

    public Object visit(After after, Object extraData) {
        return FilterToTextUtil.buildBinaryTemporalOperator("AFTER", (BinaryTemporalOperator)after, extraData);
    }

    public Object visit(Before before, Object extraData) {
        return FilterToTextUtil.buildBinaryTemporalOperator("BEFORE", (BinaryTemporalOperator)before, extraData);
    }

    public Object visit(During during, Object extraData) {
        return FilterToTextUtil.buildDuring(during, extraData);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter AnyInteracts has not a CQL expression");
    }

    public Object visit(Begins begins, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter Begins has not a CQL expression");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter BegunBy has not a CQL expression");
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter EndedBy has not a CQL expression");
    }

    public Object visit(Ends ends, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter Ends has not a CQL expression");
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter Meets has not a CQL expression");
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter MetBy has not a CQL expression");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter OverlappedBy not implemented");
    }

    public Object visit(TContains contains, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter TContains has not a CQL expression");
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter TEquals has not a CQL expression");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter TOverlaps has not a CQL expression");
    }
}

