/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import jsbugs.BiocomTableModel;
import jsbugs.table.CorrectedDepthRenderer;
import jsbugs.table.IGetValue;
import jsbugs.table.SimpleTableColumn;
import model3.Biocom;
import model3.SBdb;
import model3.Sample;
import model3.SampleDepth;
import model3.Well;

public class BiocomTableModelWithCorrection
extends BiocomTableModel {
    private Well well = null;
    private boolean displayCuttingSampleCorrections = false;
    private CorrectedDepthRenderer correctedRenderer = new CorrectedDepthRenderer(DepthUnits.M);
    private SimpleTableColumn<Biocom> correctionColumn = new SimpleTableColumn<Biocom>("Corrected", 55, SampleDepth.class, new IGetValue<Biocom>(this){
        final /* synthetic */ BiocomTableModelWithCorrection this$0;
        {
            BiocomTableModelWithCorrection biocomTableModelWithCorrection = this$0;
            Objects.requireNonNull(biocomTableModelWithCorrection);
            this.this$0 = biocomTableModelWithCorrection;
        }

        @Override
        public Object getValue(Biocom biocom) {
            if (this.this$0.well != null) {
                return this.this$0.getSampleDepth(biocom.getTopSample());
            }
            return null;
        }
    });

    private Object getSampleDepth(Sample sample) {
        try {
            if (this.displayCuttingSampleCorrections || !sample.getType().equals((Object)SampleType.CU)) {
                return SampleDepth.BuildCorrectedSampleDepth(this.well, sample);
            }
            return new SampleDepth(sample.getDepth());
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
    }

    public BiocomTableModelWithCorrection() {
        this.columns.add(1, this.correctionColumn);
    }

    @Override
    void setUnits(char units) {
        super.setUnits(units);
        this.correctedRenderer.setUnits(DepthUnits.getUnits((char)units));
    }

    @Override
    public void setBioComments(List<Biocom> comments, Well well) {
        super.setBioComments(comments, well);
        this.well = well;
    }

    @Override
    public void setupTable(JTable jTableComments, SBdb sbdb) {
        super.setupTable(jTableComments, sbdb);
        jTableComments.setDefaultRenderer(SampleDepth.class, this.correctedRenderer);
    }

    @Override
    public String getPrefString() {
        return "TMBCOMWC";
    }

    @Override
    public String getPrefOrderString() {
        return "TOBCOMWC";
    }

    @Override
    public String getAutoResizeString() {
        return "TARBCOMWC";
    }

    public void setDisplayCuttingCorrections(boolean value) {
        this.displayCuttingSampleCorrections = value;
        this.fireTableDataChanged();
    }
}

