/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.db.BasicConnectionFactory;
import com.stratadata.model3.db.ConnectionDetails;
import com.stratadata.model3.db.ConnectionDetailsHelper;
import com.stratadata.model3.db.DBDriverType;
import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbugs.chartgen.ChartGenerator;
import model3.IGDIntervalZone;
import model3.SBdb;
import util.SBException;
import util.exception.SqlCache;
import util.exception.StackError;

public class ChartGen {
    public static void main(String[] args) {
        try {
            System.out.println("Running ChartGen on: " + String.valueOf(new Date()));
            String driverName = null;
            String hostName = null;
            String instanceName = null;
            String instanceLogin = null;
            String password = null;
            String sbugslogin = null;
            String sbugspwd = null;
            String filePath = null;
            String projString = null;
            String chartTemplateName = null;
            String urlTemplate = null;
            BlockProperties.ScaleType scaleType = BlockProperties.ScaleType.MD;
            for (String arg : args) {
                if (arg.equalsIgnoreCase("-showSql")) {
                    SqlCache.setShowSql((boolean)true);
                    continue;
                }
                if (arg.toLowerCase().startsWith("driver=")) {
                    driverName = arg.substring("driver=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("host=")) {
                    hostName = arg.substring("host=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("instance=")) {
                    instanceName = arg.substring("instance=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("password=")) {
                    password = arg.substring("password=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("path=")) {
                    filePath = arg.substring("path=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("instancelogin=")) {
                    instanceLogin = arg.substring("instancelogin=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("project=")) {
                    projString = arg.substring("project=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("sbugslogin=")) {
                    sbugslogin = arg.substring("sbugslogin=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("sbugspassword=")) {
                    sbugspwd = arg.substring("sbugspassword=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("template=")) {
                    chartTemplateName = arg.substring("template=".length());
                    continue;
                }
                if (arg.toLowerCase().startsWith("url=")) {
                    urlTemplate = arg.substring("url=".length());
                    continue;
                }
                if (!arg.toLowerCase().startsWith("scaletype=")) continue;
                try {
                    scaleType = BlockProperties.ScaleType.valueOf(arg.substring("scaletype=".length()).trim());
                }
                catch (IllegalArgumentException ie) {
                    System.out.println("Error parsing scale type: " + ie.toString());
                    ie.printStackTrace();
                    System.exit(-1);
                }
            }
            if (driverName == null || hostName == null || instanceName == null || sbugslogin == null || chartTemplateName == null) {
                System.out.println("One or more connection parameters are missing.");
                if (driverName == null) {
                    System.out.println("Check driver name.");
                }
                if (hostName == null) {
                    System.out.println("Check host name.");
                }
                if (instanceName == null) {
                    System.out.println("Check instance name.");
                }
                if (sbugslogin == null) {
                    System.out.println("Check StrataBugs login name.");
                }
                if (chartTemplateName == null) {
                    System.out.println("Check template is a global chart template.");
                }
                System.exit(1);
            }
            if (!(driverName.equalsIgnoreCase("h2") || instanceLogin != null && password != null)) {
                if (instanceLogin == null) {
                    System.out.println("Check instance login.");
                }
                if (password == null) {
                    System.out.println("Check password.");
                }
            }
            if (filePath == null || !new File(filePath).isDirectory() && !filePath.contains("<")) {
                System.out.println("You must specify an existing directory for generated files using the 'path' parameter.");
                System.exit(1);
            }
            StackError.setNoGui();
            SBdb db = new SBdb();
            try {
                ConnectionDetails connectionDetails = ConnectionDetailsHelper.getConnectionDetails(DBDriverType.getDriverType(driverName), hostName, false, instanceName, instanceLogin, password, null, false);
                db.connect(new BasicConnectionFactory(connectionDetails));
                db.getDefaultUser(instanceLogin);
                db.login(sbugslogin, sbugspwd != null ? sbugspwd : password);
            }
            catch (RuntimeException | SQLException | SBException e) {
                System.out.println("Error connecting to database.");
                e.printStackTrace();
                System.exit(-1);
            }
            System.out.println("Connected to database");
            IGDIntervalZone.loadHierNames(db);
            ChartManager chartManager = new ChartManager(db);
            ChartGenerator chartGenerator = new ChartGenerator(chartManager, db, filePath, urlTemplate, scaleType);
            chartGenerator.setProject(projString);
            List<ChartTemplate> templates = chartManager.searchCharts(chartTemplateName, chartGenerator.getProject() == null ? 0 : chartGenerator.getProject().getID(), null, true, null, null, null, null, null);
            if (templates.isEmpty()) {
                templates = chartManager.searchCharts(chartTemplateName, 0, null, true, null, null, null, null, null);
            }
            ChartTemplateBase template = null;
            if (templates.isEmpty()) {
                List<BlockTemplate> bTempls = chartManager.searchBlocks(BlockType.WELL, chartTemplateName, chartGenerator.getProject() == null ? 0 : chartGenerator.getProject().getID(), null, null, null);
                if (bTempls.isEmpty()) {
                    bTempls = chartManager.searchBlocks(BlockType.WELL, chartTemplateName, 0, null, null, null);
                }
                if (!bTempls.isEmpty()) {
                    template = bTempls.get(0);
                }
            } else {
                template = templates.get(0);
            }
            if (template == null) {
                System.out.println("No templates found with name: " + chartTemplateName);
                System.exit(1);
            }
            chartGenerator.setTemplate(template);
            chartGenerator.generateCharts();
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

