/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import jsbchart.core.Chart;
import jsbchart.graphics.SBGraphics;
import jsbchart.tag.ChartTagArtist;
import jsbugs.chart.ZoomManager;
import jsbugs.chart.ZoomPanel;
import jsbugs.chart.component.JScrollPaneChartBase;
import jsbugs.uiutil.CursorFactory;

public class ChartJPanel
extends JPanel
implements Printable,
ZoomPanel,
Chart.Listener {
    private static final Logger LOGGER = Logger.getLogger(ChartJPanel.class.getName());
    private static final Cursor MARQUEE_CURSOR = CursorFactory.getMarqueeZoomCursor();
    public Chart chart;
    public static final float pixPerMM = 2.8346457f;
    private static final double GRAPHICS_SCALE = 0.028346456587314606;
    protected final ZoomManager zm = new ZoomManager(this, 0.028346456587314606);
    private final ChartTagArtist tagArtist = new ChartTagArtist();
    private KeyEventDispatcher altKeyEventDispatcher;
    boolean watermark = false;
    private Chart.Mode hMode = Chart.Mode.NORMAL;
    private Chart.Mode vMode = Chart.Mode.NORMAL;
    private boolean hModeLocked;
    private boolean vModeLocked;
    private static final Color TEXT_COLOUR = new Color(51, 102, 204);
    private boolean showCentre = false;
    private PageFormat pf = null;
    private PageFit pageFit = PageFit.FITTOPAGE;
    Integer crossHairX = null;
    Integer crossHairY = null;
    private final ArrayList<JScrollPaneChartBase> listeners = new ArrayList();
    private static final Color MARQUEE_COLOR = new Color(51, 102, 204);
    private Point2D.Float marqueeOrigin;
    private Point2D.Float marqueeEnd = null;

    void setChartMode(boolean horz, Chart.Mode mode) {
        if (horz) {
            if (this.hModeLocked && mode != this.hMode) assert (false);
            this.hMode = mode;
        } else {
            if (this.vModeLocked && mode != this.vMode) assert (false);
            this.vMode = mode;
        }
    }

    public Chart.Mode getMode(boolean horz) {
        return horz ? this.hMode : this.vMode;
    }

    public Chart.Mode hMode() {
        return this.hMode;
    }

    public Chart.Mode vMode() {
        return this.vMode;
    }

    void lockHorzMode() {
        this.hModeLocked = true;
    }

    void lockVertMode() {
        this.vModeLocked = true;
    }

    public ChartJPanel(Chart chart) {
        assert (chart != null);
        this.setBackground(chart.getProperties().background);
        this.chart = chart;
        this.init();
    }

    public ChartJPanel(Chart chart, PageFormat pf, int fit) {
        this.setBackground(Color.WHITE);
        this.chart = chart;
        this.pf = pf;
        this.pageFit = switch (fit) {
            default -> PageFit.FITTOPAGE;
            case 1 -> PageFit.TILE;
            case 2 -> PageFit.SINGLE;
        };
        this.zm.setZoom(0.3f);
        this.setSize();
        this.init();
    }

    private void init() {
        this.chart.addListener(this);
        this.altKeyEventDispatcher = new KeyEventDispatcher(this){
            final /* synthetic */ ChartJPanel this$0;
            {
                ChartJPanel chartJPanel = this$0;
                Objects.requireNonNull(chartJPanel);
                this.this$0 = chartJPanel;
            }

            @Override
            public boolean dispatchKeyEvent(KeyEvent ke) {
                switch (ke.getID()) {
                    case 401: {
                        if (ke.getKeyCode() != 18) break;
                        this.this$0.setCursor(MARQUEE_CURSOR);
                        break;
                    }
                    case 402: {
                        if (ke.getKeyCode() != 18) break;
                        this.this$0.setCursor(Cursor.getDefaultCursor());
                    }
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.altKeyEventDispatcher);
    }

    public void removeAltKeyListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.altKeyEventDispatcher);
    }

    public void terminate() {
        this.removeAltKeyListener();
    }

    void setChart(Chart chart) {
        if (chart != this.chart) {
            if (this.chart != null) {
                this.chart.deleteListener(this);
            }
            this.chart = chart;
            chart.addListener(this);
        }
    }

    public void chartProperties() {
    }

    @Override
    public void chartChanged() {
        this.repaint();
        for (JScrollPaneChartBase sPane : this.listeners) {
            sPane.refreshView();
        }
    }

    @Override
    public final void setSize() {
        this.setSize(this.getZoom());
    }

    public void setSize(float zoom) {
        this.zm.setZoom(zoom);
        if (this.chart != null) {
            this.setPreferredSize(new Dimension((int)(this.chart.getMMwidth(this.vMode) * 2.8346457f * zoom), (int)(this.chart.getMMheight(this.hMode) * 2.8346457f * zoom)));
        }
    }

    public Point getPosition(Point2D p) {
        return new Point((int)(p.getX() * 2.8346457481384277 * (double)this.getZoom()), (int)(p.getY() * 2.8346457481384277 * (double)this.getZoom()));
    }

    public Point2D.Float getPoint(Point p) {
        Point2D p2;
        AffineTransform tnf = new AffineTransform();
        tnf.scale(this.getZoom() * 2.8346457f / 100.0f, this.getZoom() * 2.8346457f / 100.0f);
        try {
            p2 = tnf.inverseTransform(p, null);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
        return new Point2D.Float((float)p2.getX() / 100.0f, (float)p2.getY() / 100.0f);
    }

    public AffineTransform setRubberBandMode(Graphics g) {
        AffineTransform saveTransform = ((Graphics2D)g).getTransform();
        AffineTransform tnf = new AffineTransform();
        tnf.scale(this.getZoom() * 2.8346457f / 100.0f, this.getZoom() * 2.8346457f / 100.0f);
        Color bg = this.getBackground();
        ((Graphics2D)g).transform(tnf);
        int origin = 0;
        g.translate(origin, origin);
        g.setXORMode(bg);
        return saveTransform;
    }

    public void clearRubberBandMode(Graphics g, AffineTransform saveTransform) {
        ((Graphics2D)g).setTransform(saveTransform);
        g.setPaintMode();
        g.dispose();
    }

    public String getTooltip(MouseEvent evt) {
        String text = null;
        if (this.chart != null) {
            Point2D.Float p = this.getPoint(evt.getPoint());
            try {
                text = this.chart.getTooltip(p, this.getZoom(), this.hMode, this.vMode);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Exception while getting tooltip text at " + String.valueOf(p) + ".", ex);
            }
        }
        return text;
    }

    public Object getObject(MouseEvent evt) {
        if (this.chart != null && this.getVisibleRect().contains(evt.getPoint())) {
            return this.chart.getObject(this.getPoint(evt.getPoint()), this.getZoom(), this.hMode, this.vMode);
        }
        return null;
    }

    public Object getObject(Point point) {
        if (this.chart != null && this.getVisibleRect().contains(point)) {
            return this.chart.getObject(this.getPoint(point), this.getZoom(), this.hMode, this.vMode);
        }
        return null;
    }

    public void drawLine(Graphics g, Point2D from, Point2D to) {
        g.drawLine((int)(from.getX() * 100.0), (int)(from.getY() * 100.0), (int)(to.getX() * 100.0), (int)(to.getY() * 100.0));
    }

    public void drawRect(Graphics g, Point2D from, float width, float height) {
        g.drawRect((int)(from.getX() * 100.0), (int)(from.getY() * 100.0), (int)(width * 100.0f), (int)(height * 100.0f));
    }

    public void drawPolygon(Graphics g, float[] xPoints, float[] yPoints) {
        if (xPoints.length != yPoints.length) {
            throw new IllegalArgumentException("different number of x points and y points");
        }
        int[] ixPoints = new int[xPoints.length];
        int[] iyPoints = new int[yPoints.length];
        for (int i = 0; i < yPoints.length; ++i) {
            ixPoints[i] = (int)(xPoints[i] * 100.0f);
            iyPoints[i] = (int)(yPoints[i] * 100.0f);
        }
        g.drawPolygon(ixPoints, iyPoints, ixPoints.length);
    }

    public void drawString(Graphics g, Point2D location, String string) {
        Color color = g.getColor();
        g.setColor(TEXT_COLOUR);
        g.setFont(new Font(this.chart.getProperties().font, 1, (int)(this.chart.getProperties().getFontSize() * 100.0f / this.getZoom() * 2.8346457f)));
        g.drawString(string, (int)(location.getX() * 100.0), (int)((location.getY() - 0.75) * 100.0));
        g.setColor(color);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.chart != null) {
            AffineTransform saveTransform = ((Graphics2D)g).getTransform();
            AffineTransform tnf = new AffineTransform();
            tnf.scale(this.zm.getAffineTransformFactor(), this.zm.getAffineTransformFactor());
            ((Graphics2D)g).transform(tnf);
            int origin = 0;
            g.translate(origin, origin);
            Point visibleRectTopLeft = new Point();
            Point visibleRectBottomRight = new Point();
            try {
                Rectangle thisVisibleRect = this.getVisibleRect();
                tnf.inverseTransform(thisVisibleRect.getLocation(), visibleRectTopLeft);
                tnf.inverseTransform(new Point(thisVisibleRect.x + this.getVisibleRect().width, thisVisibleRect.y + thisVisibleRect.height), visibleRectBottomRight);
                Rectangle transformedVisibleRect = new Rectangle(visibleRectTopLeft, new Dimension(visibleRectBottomRight.x - visibleRectTopLeft.x, visibleRectBottomRight.y - visibleRectTopLeft.y));
                transformedVisibleRect.width += origin;
                transformedVisibleRect.height += origin;
                transformedVisibleRect.x -= origin;
                transformedVisibleRect.y -= origin;
                SBGraphics sbGraphics = new SBGraphics((Graphics2D)g, transformedVisibleRect, true, true);
                sbGraphics.setOriginalTransform(saveTransform);
                sbGraphics.setZoomLevel(this.zm.getZoom());
                if (this.watermark) {
                    this.chart.drawWatermark(sbGraphics, true);
                } else {
                    this.chart.draw(sbGraphics, this.hMode, this.vMode);
                }
                this.tagArtist.drawChartTagOverlay(sbGraphics, this.chart, this.zm);
                this.drawMarquee(sbGraphics);
            }
            catch (NoninvertibleTransformException ex) {
                System.out.println("Failed inverse transform");
            }
            ((Graphics2D)g).setTransform(saveTransform);
            if (this.getPf() != null) {
                g.setColor(Color.CYAN);
                float[] dash = new float[]{10.0f};
                ((Graphics2D)g).setStroke(new BasicStroke(2.0f, 0, 0, 1.0f, dash, 10.0f));
                float imageWidth = (float)this.getPf().getImageableWidth() * this.getZoom();
                float imageHeight = (float)this.getPf().getImageableHeight() * this.getZoom();
                float mmWidth = this.chart.getMMwidth() * 2.8346457f * this.getZoom();
                float mmHeight = this.chart.getMMheight() * 2.8346457f * this.getZoom();
                if (this.pageFit == PageFit.FITTOPAGE && (mmWidth > imageWidth || mmHeight > imageHeight)) {
                    g.drawRect((int)this.chart.getProperties().margin, (int)this.chart.getProperties().margin, (int)mmWidth, (int)mmHeight);
                } else {
                    float xtrans = this.chart.getProperties().margin;
                    for (float ytrans = this.chart.getProperties().margin; ytrans < mmHeight; ytrans += imageHeight) {
                        while (xtrans < mmWidth) {
                            g.drawRect((int)xtrans, (int)ytrans, (int)imageWidth, (int)imageHeight);
                            xtrans += imageWidth;
                            if (this.pageFit != PageFit.SINGLE) continue;
                        }
                        xtrans = this.chart.getProperties().margin;
                        if (this.pageFit != PageFit.SINGLE) continue;
                    }
                }
            }
            if (this.showCentre) {
                Rectangle r = this.getVisibleRect();
                g.setColor(Color.DARK_GRAY);
                ((Graphics2D)g).setStroke(new BasicStroke(0.2f));
                g.drawLine(r.x + r.width / 2, r.y, r.x + r.width / 2, r.y + r.height);
                g.drawLine(r.x, r.y + r.height / 2, r.x + r.width, r.y + r.height / 2);
            }
        }
    }

    public void setShowCentre(boolean showCentre) {
        this.showCentre = showCentre;
    }

    public PageFormat getPf() {
        return this.pf;
    }

    public void setPf(PageFormat pf) {
        this.pf = pf;
    }

    public void setPageFit(PageFit fit) {
        this.pageFit = fit;
    }

    public PageFit getPageFit() {
        return this.pageFit;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        System.out.println("Requested to print page number: " + (pageIndex + 1));
        float imageWidth = (float)pf.getImageableWidth() / 2.8346457f;
        float imageHeight = (float)pf.getImageableHeight() / 2.8346457f;
        System.out.println(" Imageable Width (mm): " + imageWidth + " Imageable Height (mm): " + imageHeight);
        g.setFont(new Font("Arial", 1, 5));
        g.translate((int)(pf.getImageableX() + 2.8346457481384277), (int)(pf.getImageableY() + 2.8346457481384277));
        if (this.chart != null) {
            AffineTransform saveTransform = ((Graphics2D)g).getTransform();
            AffineTransform tnf = new AffineTransform();
            System.out.println("  Chart width: " + this.chart.getMMwidth() + " Chart height: " + this.chart.getMMheight());
            boolean multiple = false;
            if (this.pageFit == PageFit.FITTOPAGE && (this.chart.getMMwidth() > imageWidth || this.chart.getMMheight() > imageHeight)) {
                float wFactor = this.chart.getMMwidth() / imageWidth;
                float hFactor = this.chart.getMMheight() / imageHeight;
                float factor = Math.max(wFactor, hFactor);
                factor = (float)((double)factor * 1.05);
                System.out.println("  Plot request at scale factor " + factor);
                tnf.scale(0.028346457f / factor, 0.028346457f / factor);
            } else {
                if (this.pageFit == PageFit.SINGLE && (imageWidth < this.chart.getMMwidth() || imageHeight < this.chart.getMMheight())) {
                    throw new PrinterAbortException("Printing stopped: there is not enough space to plot chart on a single page at true scale.");
                }
                multiple = true;
                System.out.println("  Plot request at natural scale...");
                tnf.scale(0.028346456587314606, 0.028346456587314606);
            }
            float xtrans = 0.0f;
            float ytrans = 0.0f;
            if (multiple) {
                int pageNo = 0;
                while (pageNo < pageIndex) {
                    if (xtrans + imageWidth < this.chart.getMMwidth()) {
                        xtrans += imageWidth;
                        ++pageNo;
                        continue;
                    }
                    if (ytrans + imageHeight < this.chart.getMMheight()) {
                        ytrans += imageHeight;
                        xtrans = 0.0f;
                        ++pageNo;
                        continue;
                    }
                    System.out.println("  Page is outside chart dimensions. Printing finished.");
                    return 1;
                }
            } else if (pageIndex >= 1) {
                return 1;
            }
            if (multiple && pageIndex > 0) {
                g.translate((int)(xtrans * -1.0f * 2.8346457f), (int)(ytrans * -1.0f * 2.8346457f));
            }
            ((Graphics2D)g).transform(tnf);
            SBGraphics sbGraphics = new SBGraphics((Graphics2D)g, null, true, true);
            System.out.println("  Drawing page ...");
            if (this.watermark) {
                this.chart.drawWatermark(sbGraphics, false);
            } else {
                this.chart.draw(sbGraphics, Chart.Mode.NORMAL, Chart.Mode.NORMAL);
            }
            ((Graphics2D)g).setTransform(saveTransform);
        }
        return 0;
    }

    public UndoManager getUndoManager() {
        return null;
    }

    public UndoableEditSupport getUndoSupport() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCrosshair(MouseEvent evt, boolean thisIsView, EvtOrigin origin) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        try {
            boolean thisIsColumnHeader;
            boolean thisIsRowHeader;
            g.setXORMode(this.getBackground());
            if (this.crossHairY != null) {
                g.drawLine(0, this.crossHairY, this.getMaximumSize().width, this.crossHairY);
            }
            this.crossHairY = null;
            boolean bl = thisIsRowHeader = !thisIsView && this.getMode(false) == Chart.Mode.HEADER_ONLY;
            if (evt != null && (evt.getSource() == this || thisIsView && origin == EvtOrigin.ROW_HEADER || thisIsRowHeader && origin == EvtOrigin.VIEW)) {
                this.crossHairY = evt.getPoint().y;
                g.drawLine(0, this.crossHairY, this.getMaximumSize().width, this.crossHairY);
            }
            if (this.crossHairX != null) {
                g.drawLine(this.crossHairX, 0, this.crossHairX, this.getMaximumSize().height);
            }
            this.crossHairX = null;
            boolean bl2 = thisIsColumnHeader = !thisIsView && this.getMode(true) == Chart.Mode.HEADER_ONLY;
            if (evt != null && (evt.getSource() == this || thisIsView && origin == EvtOrigin.COLUMN_HEADER || thisIsColumnHeader && origin == EvtOrigin.VIEW)) {
                this.crossHairX = evt.getPoint().x;
                g.drawLine(this.crossHairX, 0, this.crossHairX, this.getMaximumSize().height);
            }
        }
        finally {
            g.setPaintMode();
        }
    }

    @Override
    public void repaint() {
        this.crossHairX = null;
        this.crossHairY = null;
        super.repaint();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void addListener(JScrollPaneChartBase listener) {
        this.listeners.add(listener);
    }

    public ZoomManager getZoomManager() {
        return this.zm;
    }

    public float getZoom() {
        return this.zm.getZoom();
    }

    public void setMarquee(Point2D.Float origin, Point2D.Float end) {
        this.marqueeEnd = end;
        this.marqueeOrigin = origin;
    }

    public void clearMarquee() {
        this.marqueeOrigin = null;
        this.marqueeEnd = null;
    }

    private void drawMarquee(SBGraphics g) {
        if (this.marqueeOrigin != null && this.marqueeEnd != null) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.setFrameFromDiagonal(this.marqueeOrigin, this.marqueeEnd);
            g.drawRect(rect, MARQUEE_COLOR);
        }
    }

    public boolean hasMarquee() {
        return this.marqueeOrigin != null && this.marqueeEnd != null;
    }

    static enum PageFit {
        FITTOPAGE,
        TILE,
        SINGLE;

    }

    public static enum EvtOrigin {
        VIEW,
        ROW_HEADER,
        COLUMN_HEADER;

    }
}

