/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import jsbugs.GUI;
import jsbugs.InteractiveChartJPanel;
import jsbugs.JPanelCharts;
import model3.IGDScheme;
import model3.Well;
import model3.WellInterp;
import util.SBException;
import util.SBPermissionException;

public class ChartJPanelAHD
extends InteractiveChartJPanel {
    private static final Logger LOGGER = Logger.getLogger(ChartJPanelAHD.class.getName());
    boolean ahdChartPropertiesDecoded = false;
    boolean ahdDepthsSet = false;
    private AHDupdateMode updateMode = AHDupdateMode.AUTO_UPDATE;
    private int copiedBlockTemplate;
    static final PanelType[] panelTypes = new PanelType[]{PanelType.SCALE, PanelType.CASING, PanelType.CORES, PanelType.COREIMAGES, PanelType.WLOG, PanelType.CHRONOZONE, PanelType.LITHOZONE, PanelType.MICROZONE, PanelType.NANNOZONE, PanelType.PALYZONE, PanelType.MACROZONE, PanelType.SAMPLES, PanelType.INTLITH, PanelType.SAMPLELITH, PanelType.SQPICK, PanelType.EVENT, PanelType.BIOCOMS, PanelType.ENV, PanelType.MICRO, PanelType.PALY, PanelType.NANNO, PanelType.MACRO, PanelType.INTCOM, PanelType.MARKERS};
    private final HashMap<PanelType, SBPanel> removedPanels = new HashMap();

    public ChartJPanelAHD(JPanelCharts parent) {
        super(new Chart(), parent, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initChart(boolean create, BlockProperties bp) {
        LOGGER.config("Setting up AHD Chart...");
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean setData = false;
        try {
            if (this.chart.getBlocks().isEmpty()) {
                WellBlock block;
                this.chart.getProperties().setPanelHeaderHeight(90.0f);
                this.chart.getProperties().setPanelCaptionHeight(9.0f);
                this.chart.getProperties().margin = 3.0f;
                this.chart.getProperties().plotBlockCaptions = false;
                Well well = this.parent.parentPanel.well;
                if (bp != null) {
                    block = new WellBlock(well, this.parent.sbdb, bp);
                } else {
                    block = new WellBlock(well, this.parent.sbdb);
                    if (this.parent.getInterp() != null) {
                        block.setInterpID(this.parent.getInterp().getHeader().getInterpID());
                    }
                    block.setDefaultProperties();
                }
                ChartManager chartManager = this.parent.parent.getParent().getChartManager();
                for (PanelType type : panelTypes) {
                    this.addPanel(type, block, chartManager, false);
                }
                chartManager.addPanelDefaultListener(block);
                block.enable();
                this.chart.addBlock(block);
                setData = true;
            } else {
                WellInterp wellInterp = this.parent.getInterp();
                if (wellInterp != null) {
                    for (ChartBlockBase block : this.chart.getBlocks()) {
                        block.setInterpID(wellInterp.getHeader().getInterpID());
                    }
                }
                if (create && this.updateMode == AHDupdateMode.AUTO_UPDATE) {
                    WellBlock block = (WellBlock)this.chart.getBlockSingle();
                    assert (block != null && block.getWell() == this.parent.parentPanel.well);
                    ChartManager chartManager = this.parent.parent.getParent().getChartManager();
                    for (PanelType type : panelTypes) {
                        setData = this.addPanel(type, block, chartManager, true) || setData;
                    }
                }
            }
            if (setData) {
                this.chart.setData();
            }
            if (this.parent.getInterp() != null) {
                this.parent.setJLabelInfoColour(Color.BLACK);
            } else {
                this.parent.setJLabelInfoColour(Color.RED);
                this.parent.setJLabelInfoText("Warning: no version loaded");
            }
            if (this.chart.calcChartSize()) {
                GUI.setScrollPaneSize(this, this.getZoom(), 1.25f);
                this.parent.setChartSizeLabel();
            }
            this.repaint();
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void setUpdateMode(AHDupdateMode updateMode, int copiedBlockTemplate) {
        this.updateMode = updateMode;
        this.copiedBlockTemplate = copiedBlockTemplate;
    }

    void resetChart() {
        BlockProperties bp = null;
        for (ChartBlock block : this.chart.getChartBlocks()) {
            bp = block.getProp();
            this.chart.removeBlock(block);
        }
        this.setUpdateMode(AHDupdateMode.AUTO_UPDATE, 0);
        this.initChart(true, bp);
    }

    int getCopiedBlockTemplate() {
        return this.copiedBlockTemplate;
    }

    private boolean addPanel(PanelType panelType, WellBlock block, ChartManager chartManager, boolean checkRemoved) throws SQLException, SBException, SBPermissionException {
        for (SBPanel panel : block.getPanels()) {
            if (panel.getPanelType() != panelType) continue;
            return false;
        }
        if (checkRemoved && this.removedPanels.get(panelType) != null) {
            return false;
        }
        WellInterp interp = this.parent.getInterp();
        if (interp == null && panelType.isInterpPanel()) {
            return false;
        }
        if (ChartJPanelAHD.hasData(panelType, block, interp)) {
            if (PanelType.isBiozonePanel(panelType)) {
                Iterator<IGDScheme> itS = interp.getIGDSchemes(4).iterator();
                boolean added = false;
                while (itS.hasNext()) {
                    IGDScheme scheme = itS.next();
                    if (scheme.getDiscipline() != panelType.getDiscipine()) continue;
                    scheme.loadUnits();
                    PanelTemplate defaultPanelTemplate = chartManager.getDefaultPanelTemplate(panelType);
                    PanelOcc occ = new PanelOcc(defaultPanelTemplate.getID(), null, null, null, null, scheme.getID());
                    block.addPanel((SBPanel)PanelFactory.createPanel(block, defaultPanelTemplate, occ));
                    added = true;
                }
                return added;
            }
            block.addPanel((SBPanel)PanelFactory.createPanel(block, chartManager.getDefaultPanelTemplate(panelType), null));
            return true;
        }
        return false;
    }

    static boolean hasData(PanelType panelType, WellBlock block, WellInterp interp) throws SQLException, SBException {
        switch (panelType) {
            case SCALE: {
                return true;
            }
            case SAMPLES: {
                return block.getWell().getSamples() != null && !block.getWell().getSamples().isEmpty();
            }
            case MICRO: 
            case PALY: 
            case NANNO: 
            case MACRO: {
                return !block.getWell().getAnalyses(panelType.getDiscipine(), null, 0).isEmpty();
            }
            case WLOG: {
                return block.getWell().getCurveService().getCurveCount() > 0;
            }
            case INTLITH: {
                return !block.getWell().getLithIntervals().isEmpty();
            }
            case SAMPLELITH: {
                return block.getWell().hasSampleLithology();
            }
            case CASING: {
                return !block.getWell().getCasing().getList().isEmpty();
            }
            case MARKERS: {
                return !block.getWell().getMarkers().getList().isEmpty();
            }
            case CORES: {
                return !block.getWell().getCores().getList().isEmpty();
            }
            case COREIMAGES: {
                return !block.getWell().getCoreImages().isEmpty();
            }
            case CHRONOZONE: {
                return interp != null && interp.hasData(3);
            }
            case LITHOZONE: {
                return interp != null && interp.hasData(2);
            }
            case MICROZONE: 
            case PALYZONE: 
            case MACROZONE: 
            case NANNOZONE: {
                return interp != null && interp.hasData(4);
            }
            case SQPICK: {
                return interp != null && interp.hasData(21);
            }
            case ENV: {
                return interp != null && interp.hasData(5);
            }
            case INTCOM: {
                return interp != null && interp.hasData(22);
            }
            case BIOCOMS: {
                return interp != null && interp.hasData(19);
            }
            case EVENT: {
                return interp != null && !interp.getEvents().isEmpty();
            }
        }
        return false;
    }

    void putRemovedPanels(List<SBPanel> panels) {
        for (SBPanel panel : panels) {
            this.removedPanels.put(panel.getPanelType(), panel);
        }
    }

    public static enum AHDupdateMode {
        AUTO_UPDATE,
        NO_UPDATE;

    }
}

