/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import jsbchart.block.WellBlock;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartProperties;
import jsbchart.panel.SBPanel;
import jsbugs.DialogSelectIGDPanel;
import jsbugs.FrameJsbugs;
import jsbugs.SbugsFocusTraversalPolicy;
import jsbugs.chart.DialogChartProperties;
import model3.SBdb;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SbugsInputVerifier;

public class DialogAHDchart
extends SBDialog {
    private static final int DEPTHLEN = 8;
    private final WellBlock block;
    private char units;
    private final SBdb db;
    private final DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    private final DefaultListModel panelModel = new DefaultListModel();
    private final ChartProperties cp;
    private final WellInterp wellInterp;
    private final ChartManager chartManager;
    SbugsFocusTraversalPolicy focusPolicy = null;
    boolean ahdDepthsSet = false;
    LinkedList<SBPanel> removedPanels = new LinkedList();
    boolean resetPanels = false;
    private ButtonGroup buttonGroupAgeAxis;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonAddPanel;
    private JButton jButtonCancel;
    private JButton jButtonFonts;
    private JButton jButtonHelp;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonOK;
    private JButton jButtonRemovePanel;
    private JButton jButtonReset;
    private JComboBox jComboBoxVerticalScale;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList jListPanels;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldTopDepth;

    public DialogAHDchart(JFrame parent, boolean modal, SBdb db, WellBlock block, ChartProperties cp, WellInterp wellInterp, ChartManager chartManager) throws SQLException {
        super((Frame)parent, modal);
        this.chartManager = chartManager;
        this.block = block;
        this.db = db;
        this.cp = cp;
        this.wellInterp = wellInterp;
        this.initComponents();
        this.init();
        this.initFocus();
    }

    private void init() throws SQLException {
        this.jTextFieldTopDepth.setText(SB.floatString((float)DepthUtils.convFromM((float)this.block.getTopDepth(), (char)this.block.getProp().getUnits(), (char)this.block.getWell().getType()), (int)2));
        this.jTextFieldBaseDepth.setText(SB.floatString((float)DepthUtils.convFromM((float)this.block.getBaseDepth(), (char)this.block.getProp().getUnits(), (char)this.block.getWell().getType()), (int)2));
        ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)new SbugsInputVerifier(1.0f, 100000.0f, (float)((int)this.block.getScale())));
        this.db.getChartScales(this.scaleModel);
        String sScale = Integer.toString((int)this.block.getScale());
        if (this.scaleModel.getIndexOf(sScale) < 0) {
            this.scaleModel.addElement(sScale);
        }
        this.scaleModel.setSelectedItem(sScale);
        if (this.block.getProp().getUnits() == 'F') {
            this.jRadioButtonFeet.setSelected(true);
        } else {
            this.jRadioButtonMetres.setSelected(true);
        }
        this.units = this.block.getProp().getUnits();
        this.setTitle("Untemplated Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jListPanels.setCellRenderer(new ListCellRenderer(this){
            JLabel label;
            private final Font plainFont;
            private final Font boldFont;
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
                this.label = new JLabel();
                this.label.setOpaque(true);
                this.plainFont = this.label.getFont().deriveFont(0);
                this.boldFont = this.label.getFont().deriveFont(1);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                block6: {
                    this.label.setIcon(null);
                    if (value != null && value instanceof SBPanel) {
                        SBPanel panel = (SBPanel)value;
                        this.label.setIcon(panel.getPanelType().getIcon());
                        this.label.setText(value.toString());
                        try {
                            if (panel.getProperties() != this.this$0.chartManager.getPanelTemplate(panel.getTemplateID()).getProperties()) {
                                this.label.setFont(this.boldFont);
                                break block6;
                            }
                            this.label.setFont(this.plainFont);
                        }
                        catch (Exception e) {
                            this.label.setFont(this.plainFont);
                            e.printStackTrace();
                        }
                    } else {
                        assert (false);
                        this.label.setText("null");
                    }
                }
                this.label.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
                this.label.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                return this.label;
            }
        });
        this.initPanelList();
    }

    private void initFocus() {
        LinkedList<Component> focusOrder = new LinkedList<Component>();
        focusOrder.add(this.jTextFieldTopDepth);
        focusOrder.add(this.jTextFieldBaseDepth);
        focusOrder.add(this.jComboBoxVerticalScale);
        focusOrder.add(this.jRadioButtonMetres);
        focusOrder.add(this.jRadioButtonFeet);
        focusOrder.add(this.jButtonFonts);
        focusOrder.add(this.jListPanels);
        focusOrder.add(this.jButtonAddPanel);
        focusOrder.add(this.jButtonRemovePanel);
        focusOrder.add(this.jButtonMoveUp);
        focusOrder.add(this.jButtonMoveDown);
        focusOrder.add(this.jButtonOK);
        focusOrder.add(this.jButtonHelp);
        focusOrder.add(this.jButtonCancel);
        this.focusPolicy = new SbugsFocusTraversalPolicy(focusOrder);
        this.setFocusTraversalPolicy(this.focusPolicy);
    }

    private void initPanelList() {
        this.panelModel.clear();
        for (SBPanel panel : this.block.getPanels()) {
            this.panelModel.addElement(panel);
        }
        this.jListPanels.repaint();
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupAgeAxis = new ButtonGroup();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBoxVerticalScale = new JComboBox();
        this.jTextFieldTopDepth = new JTextField();
        this.jTextFieldBaseDepth = new JTextField();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListPanels = new JList();
        this.jLabel4 = new JLabel();
        this.jButtonRemovePanel = new JButton();
        this.jButtonFonts = new JButton();
        this.jButtonAddPanel = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonReset = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(465, 420));
        this.setModal(true);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Top depth:");
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Base depth:");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Scale:");
        this.jComboBoxVerticalScale.setEditable(true);
        this.jComboBoxVerticalScale.setModel(this.scaleModel);
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setSelected(true);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMetres).addPreferredGap(1).add((Component)this.jRadioButtonFeet).addContainerGap(22, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)));
        this.jListPanels.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListPanels.setModel(this.panelModel);
        this.jListPanels.setToolTipText("Panels with bold names have modified properties");
        this.jScrollPane1.setViewportView(this.jListPanels);
        this.jLabel4.setText("Panels:");
        this.jButtonRemovePanel.setText("Remove");
        this.jButtonRemovePanel.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonRemovePanel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemovePanelActionPerformed(evt);
            }
        });
        this.jButtonFonts.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/chartProperties16.png")));
        this.jButtonFonts.setText("Options...");
        this.jButtonFonts.setToolTipText("Chart display options, including fonts and core corrections");
        this.jButtonFonts.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonFonts.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFontsActionPerformed(evt);
            }
        });
        this.jButtonAddPanel.setText("Add...");
        this.jButtonAddPanel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddPanelActionPerformed(evt);
            }
        });
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setToolTipText("Panel moves left in chart");
        this.jButtonMoveUp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveUpActionPerformed(evt);
            }
        });
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setToolTipText("Panel moves right in chart");
        this.jButtonMoveDown.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveDown.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveDownActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonReset.setText("Reset chart...");
        this.jButtonReset.setToolTipText("Recreate chart using default panel templates for all available data types");
        this.jButtonReset.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAHDchart this$0;
            {
                DialogAHDchart dialogAHDchart = this$0;
                Objects.requireNonNull(dialogAHDchart);
                this.this$0 = dialogAHDchart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonResetActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).add(410, 410, 410)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabel1).add(2, (Component)this.jLabel2).add(2, (Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jTextFieldTopDepth).add(1, (Component)this.jTextFieldBaseDepth, -2, 106, -2)).add(2, (Component)this.jComboBoxVerticalScale, -2, 106, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.jButtonFonts)).add(0, 0, Short.MAX_VALUE)).add((Component)this.jSeparator2).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonReset).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).add(6, 6, 6).add((Component)this.jButtonCancel)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonRemovePanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonMoveUp, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonMoveDown, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTopDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldBaseDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jComboBoxVerticalScale, -2, -1, -2).add((Component)this.jButtonFonts))).add((Component)this.jPanel1, -2, -1, -2)).addPreferredGap(1).add((Component)this.jSeparator2, -2, 7, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAddPanel).addPreferredGap(0).add((Component)this.jButtonRemovePanel).addPreferredGap(0).add((Component)this.jButtonMoveUp).addPreferredGap(0).add((Component)this.jButtonMoveDown).add(0, 0, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 187, Short.MAX_VALUE)).add(18, 18, 18).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonReset)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean change = false;
        if (!this.panelModel.equals(this.block.getPanels())) {
            this.block.clearPanels();
            for (int i = 0; i < this.panelModel.size(); ++i) {
                this.block.addPanel((SBPanel)this.panelModel.getElementAt(i));
            }
            change = true;
        }
        assert (this.units == (this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M'));
        if (this.block.getProp().setUnits(this.units)) {
            change = true;
        }
        float topDepth = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
        float baseDepth = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
        float scale = Float.parseFloat(String.valueOf(this.jComboBoxVerticalScale.getSelectedItem()));
        if (topDepth > baseDepth) {
            if (this.block.getWell().getType() == 'W') {
                JOptionPane.showMessageDialog((Component)((Object)this), "Top depth is greater than base depth", this.getTitle(), 2);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Top depth is less than base depth", this.getTitle(), 2);
            }
            return;
        }
        if ((double)Math.abs(this.block.getTopDepth() - topDepth) > 0.001 || (double)Math.abs(this.block.getBaseDepth() - baseDepth) > 0.001) {
            this.ahdDepthsSet = true;
        }
        if (this.block.getProp().setLimits(topDepth, baseDepth)) {
            change = true;
        }
        if (scale == 0.0f) {
            scale = baseDepth - topDepth;
        }
        if (this.block.getProp().setScale(scale)) {
            change = true;
        }
        this.block.setUnits(DepthUnits.getUnits((char)this.units));
        if (change) {
            this.setOK();
        } else {
            this.dispose();
        }
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jButtonRemovePanelActionPerformed(ActionEvent evt) {
        Object[] panels;
        if (this.jListPanels.getSelectedValue() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No panel selected", this.getTitle(), 1);
            return;
        }
        for (Object o : panels = this.jListPanels.getSelectedValues()) {
            if (!(o instanceof SBPanel)) continue;
            SBPanel panel = (SBPanel)o;
            this.panelModel.removeElement(panel);
            this.removedPanels.add(panel);
        }
        this.jListPanels.updateUI();
    }

    private void jButtonFontsActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogChartProperties dialog = new DialogChartProperties((JDialog)((Object)this), true, this.cp, this.db);
        dialog.setLocationRelativeTo((Component)((Object)this));
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            System.out.println("no changes to chartproperts");
        }
    }

    private void jButtonAddPanelActionPerformed(ActionEvent evt) {
        if (this.wellInterp == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No version selected", this.getTitle(), 1);
            return;
        }
        DialogSelectIGDPanel dialog = new DialogSelectIGDPanel(this, true, this.db, this.block, "Select panels", this.wellInterp, this.chartManager);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK() && dialog.panel != null) {
            this.panelModel.addElement(dialog.panel);
        }
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        this.getOnePanel(this.jListPanels.getSelectedIndices().length);
        this.movePanel(true, this.jListPanels.getSelectedIndex());
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        this.getOnePanel(this.jListPanels.getSelectedIndices().length);
        this.movePanel(false, this.jListPanels.getSelectedIndex());
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_chartstab.html#standardchart");
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Chart will be recreated using available data types with default panel templates.", this.getTitle(), 2);
        if (opt != 0) {
            return;
        }
        this.resetPanels = true;
        this.dispose();
    }

    private void setUnits() {
        if (this.jRadioButtonFeet.isSelected() && this.units != 'F') {
            this.units = (char)70;
            try {
                this.jTextFieldTopDepth.setText(SB.floatString((double)DepthUtils.convFromM((double)Double.parseDouble(this.jTextFieldTopDepth.getText()), (char)'F'), (int)2));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText(SB.floatString((double)DepthUtils.convFromM((double)Double.parseDouble(this.jTextFieldBaseDepth.getText()), (char)'F'), (int)2));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        } else if (this.jRadioButtonMetres.isSelected() && this.units != 'M') {
            this.units = (char)77;
            try {
                this.jTextFieldTopDepth.setText(SB.floatString((double)DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldTopDepth.getText()), (char)'F'), (int)2));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText(SB.floatString((double)DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldBaseDepth.getText()), (char)'F'), (int)2));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        }
    }

    private void movePanel(boolean up, int index) {
        if (index == this.panelModel.getSize() - 1 && !up) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't move down", this.getTitle(), 2);
            return;
        }
        if (index == 0 && up) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't move up", this.getTitle(), 2);
            return;
        }
        Object panel = this.panelModel.remove(index);
        this.panelModel.add(up ? index - 1 : index + 1, panel);
        this.jListPanels.repaint();
        this.jListPanels.setSelectedIndex(up ? index - 1 : index + 1);
    }

    private void getOnePanel(int len) {
        if (len != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), len > 1 ? "Select one panel" : "Select a panel", this.getTitle(), 2);
        }
    }
}

