/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.curve.Curve;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogAgeCurveProperties;
import jsbugs.DialogList;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.AgeCurve;
import model3.IGDScheme;
import model3.SBRestrictable;
import model3.SBdb;
import util.SBException;
import util.SBPermissionException;

public class DialogAgeCurve
extends SBDialog {
    private final TableModelAgeCurve model = new TableModelAgeCurve();
    private final SBdb db;
    int schID = -1;
    Color newColour = null;
    Integer newStyle = null;
    Float newLineWidth = null;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonOK;
    private JButton jButtonScheme;
    private JButton jButtonStyle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableCurve;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldTitle;
    private JTextField jTextFieldUnits;

    public DialogAgeCurve(Dialog parent, boolean modal, AgeCurve curve, SBdb db) {
        super((Window)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(curve);
    }

    private void init(AgeCurve curve) {
        this.setTitle((curve.getCurveID() == 0 ? "Add" : "Edit") + " Age Curve : " + curve.getTitle());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        TableUtils.setTableHeaderBold((JTable)this.jTableCurve);
        TableColumnModel columnModel = this.jTableCurve.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelAgeCurve.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelAgeCurve.widths[i]);
        }
        this.model.curve = curve;
        this.jTableCurve.updateUI();
        try {
            this.jTextFieldTitle.setText(curve.getTitle());
            this.jTextFieldUnits.setText(curve.getUnits());
            IGDScheme scheme = this.db.getIGDScheme(curve.getSchID());
            this.jTextFieldScheme.setText(scheme != null ? scheme.toString() : null);
            this.schID = curve.getSchID();
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCurve = new JTable();
        this.jButtonDelete = new JButton();
        this.jButtonStyle = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jTextFieldTitle = TextFieldUtils.buildLimitedLengthTextField(80);
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldUnits = TextFieldUtils.buildLimitedLengthTextField(25);
        this.jLabel3 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonScheme = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTableCurve.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCurve);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurve this$0;
            {
                DialogAgeCurve dialogAgeCurve = this$0;
                Objects.requireNonNull(dialogAgeCurve);
                this.this$0 = dialogAgeCurve;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonStyle.setText("Style...");
        this.jButtonStyle.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurve this$0;
            {
                DialogAgeCurve dialogAgeCurve = this$0;
                Objects.requireNonNull(dialogAgeCurve);
                this.this$0 = dialogAgeCurve;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonStyleActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurve this$0;
            {
                DialogAgeCurve dialogAgeCurve = this$0;
                Objects.requireNonNull(dialogAgeCurve);
                this.this$0 = dialogAgeCurve;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Title:");
        this.jLabel2.setText("Units:");
        this.jLabel3.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jButtonScheme.setText("...");
        this.jButtonScheme.setToolTipText("Select a scheme");
        this.jButtonScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurve this$0;
            {
                DialogAgeCurve dialogAgeCurve = this$0;
                Objects.requireNonNull(dialogAgeCurve);
                this.this$0 = dialogAgeCurve;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSchemeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldTitle, -1, 260, Short.MAX_VALUE).addComponent(this.jTextFieldUnits, -2, 140, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldScheme, -1, 225, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonScheme, -2, 29, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldTitle, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldUnits, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldScheme, -2, -1, -2).addComponent(this.jButtonScheme)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurve this$0;
            {
                DialogAgeCurve dialogAgeCurve = this$0;
                Objects.requireNonNull(dialogAgeCurve);
                this.this$0 = dialogAgeCurve;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 226, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonStyle, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStyle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 105, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 209, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCurve.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No row selected", this.getTitle(), 1);
            return;
        }
        int count = this.jTableCurve.getSelectedRowCount();
        int option = JOptionPane.showConfirmDialog((Component)((Object)this), "Really delete " + (count == 1 ? "this " : "these ") + count + " row" + (count == 1 ? "?" : "s?") + " You cannot undo this action.", this.getTitle(), 0, 3);
        if (option != 0) {
            return;
        }
        LinkedList<AgeCurve.AgeCurveValue> toDelete = new LinkedList<AgeCurve.AgeCurveValue>();
        try {
            for (int row : this.jTableCurve.getSelectedRows()) {
                toDelete.add(this.model.curve.getTrace().get(row));
            }
            Object object = toDelete.iterator();
            while (object.hasNext()) {
                AgeCurve.AgeCurveValue cv = (AgeCurve.AgeCurveValue)object.next();
                this.model.curve.deleteRow(this.db, cv);
            }
            this.db.commit();
            this.model.curve.notifyObservers();
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonStyleActionPerformed(ActionEvent evt) {
        DialogAgeCurveProperties dialog = new DialogAgeCurveProperties((Dialog)((Object)this), true, this.model.curve);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.newColour = dialog.colour;
            this.newLineWidth = Float.valueOf(dialog.lineWidth);
            this.newStyle = dialog.style;
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String title = this.jTextFieldTitle.getText();
        if (title.trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a title", this.getTitle(), 1);
            this.jTextFieldTitle.requestFocusInWindow();
            return;
        }
        String units = this.jTextFieldUnits.getText();
        if (units.trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must enter units", this.getTitle(), 1);
            this.jTextFieldUnits.requestFocusInWindow();
            return;
        }
        if (this.model.curve != null) {
            try {
                this.model.curve.setTitle(title);
                this.model.curve.setUnits(units);
                this.model.curve.setSchID(this.schID);
                if (this.newColour != null) {
                    this.model.curve.setColour(this.newColour);
                }
                if (this.newLineWidth != null) {
                    this.model.curve.setLineWidth(this.newLineWidth.floatValue());
                }
                if (this.newStyle != null) {
                    this.model.curve.setStyle(this.newStyle);
                }
                if (this.model.curve.getCurveID() > 0) {
                    this.model.curve.updateAttributes(this.db);
                } else {
                    this.db.addAgeCurve(this.model.curve);
                }
                this.db.commit();
            }
            catch (SQLException | SBException | SBPermissionException e) {
                this.db.doRollback();
                SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
            }
        }
        this.setOK();
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        try {
            List<IGDScheme> schemes = this.db.getIGDSchemes(3, this.db.getIGDScheme(this.schID));
            Collections.sort(schemes);
            DialogList<IGDScheme> dialog = new DialogList<IGDScheme>((JDialog)((Object)this), true, "Select Scheme", null, schemes, true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.schID = dialog.getSelection().getID();
                this.jTextFieldScheme.setText(dialog.getSelection().toString());
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error loading schemes", sql, (Component)((Object)this));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private static class TableModelAgeCurve
    extends AbstractTableModel {
        AgeCurve curve;
        static String[] titles = new String[]{"Age", "Value"};
        static int[] widths = new int[]{30, 30};

        private TableModelAgeCurve() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.curve == null) {
                return 0;
            }
            return this.curve.getTrace().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            AgeCurve.AgeCurveValue curveValue = this.curve.getTrace().get(row);
            switch (col) {
                case 0: {
                    return curveValue.getAge();
                }
                case 1: {
                    return curveValue.getValue();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: 
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Curve.CurveValue.class;
                }
            }
            return Object.class;
        }

        public void load(AgeCurve curve) {
            this.curve = curve;
        }
    }
}

