/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogAgeCurveProperties;
import jsbugs.DialogFilePreview;
import jsbugs.DialogList;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.IGDScheme;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;

public class DialogAgeCurveReader
extends SBDialog {
    private final SBdb db;
    Color colour = Color.BLACK;
    int style = 0;
    float lineWidth = 0.1f;
    String title;
    String units;
    String filePath;
    int schID = -1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonProps;
    private JButton jButtonScheme;
    private JButton jButtonView;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JTextField jTextFieldFilename;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldTitle;
    private JTextField jTextFieldUnits;

    public DialogAgeCurveReader(Dialog parent, boolean modal, SBdb db, String filePath) {
        super((Window)parent, modal);
        this.filePath = filePath;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Age Curve Reader");
        this.getRootPane().setDefaultButton(this.jButtonScheme);
        this.jTextFieldFilename.setText(this.filePath);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldFilename = new JTextField();
        this.jButtonView = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonScheme = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldTitle = TextFieldUtils.buildLimitedLengthTextField(80);
        this.jTextFieldUnits = TextFieldUtils.buildLimitedLengthTextField(25);
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonProps = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Filename:");
        this.jTextFieldFilename.setEditable(false);
        this.jTextFieldFilename.setBackground(new Color(240, 240, 240));
        this.jButtonView.setText("View...");
        this.jButtonView.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurveReader this$0;
            {
                DialogAgeCurveReader dialogAgeCurveReader = this$0;
                Objects.requireNonNull(dialogAgeCurveReader);
                this.this$0 = dialogAgeCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonViewActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jButtonScheme.setText("...");
        this.jButtonScheme.setToolTipText("Select scheme from a list");
        this.jButtonScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurveReader this$0;
            {
                DialogAgeCurveReader dialogAgeCurveReader = this$0;
                Objects.requireNonNull(dialogAgeCurveReader);
                this.this$0 = dialogAgeCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSchemeActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Title:");
        this.jLabel4.setText("Units:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurveReader this$0;
            {
                DialogAgeCurveReader dialogAgeCurveReader = this$0;
                Objects.requireNonNull(dialogAgeCurveReader);
                this.this$0 = dialogAgeCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurveReader this$0;
            {
                DialogAgeCurveReader dialogAgeCurveReader = this$0;
                Objects.requireNonNull(dialogAgeCurveReader);
                this.this$0 = dialogAgeCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurveReader this$0;
            {
                DialogAgeCurveReader dialogAgeCurveReader = this$0;
                Objects.requireNonNull(dialogAgeCurveReader);
                this.this$0 = dialogAgeCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonProps.setText("Style properties...");
        this.jButtonProps.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurveReader this$0;
            {
                DialogAgeCurveReader dialogAgeCurveReader = this$0;
                Objects.requireNonNull(dialogAgeCurveReader);
                this.this$0 = dialogAgeCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPropsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 481, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel4).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jTextFieldTitle, -1, 315, Short.MAX_VALUE).add((Component)this.jTextFieldScheme, -1, 315, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonScheme, -2, 30, -2).addPreferredGap(0, 9, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldFilename, -1, 354, Short.MAX_VALUE).addPreferredGap(0))).add((Component)this.jButtonView)).add((Component)this.jTextFieldUnits, -2, 198, -2).add((Component)this.jButtonProps))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldFilename, -2, -1, -2).add((Component)this.jButtonView).add((Component)this.jLabel1)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldScheme, -2, -1, -2).add((Component)this.jButtonScheme)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldUnits, -2, -1, -2)).addPreferredGap(0).add((Component)this.jButtonProps).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).add(16, 16, 16)));
        this.pack();
    }

    private void jButtonPropsActionPerformed(ActionEvent evt) {
        DialogAgeCurveProperties dialog = new DialogAgeCurveProperties((Dialog)((Object)this), true, null);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.colour = dialog.colour;
            this.style = dialog.style;
            this.lineWidth = dialog.lineWidth;
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.schID < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must select a scheme", "Select a scheme", 1);
            return;
        }
        this.title = this.jTextFieldTitle.getText();
        if (this.title.trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a title", "Title", 1);
            this.jTextFieldTitle.requestFocusInWindow();
            return;
        }
        this.units = this.jTextFieldUnits.getText();
        if (this.units.trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter units", "Units", 1);
            this.jTextFieldUnits.requestFocusInWindow();
            return;
        }
        this.setOK();
    }

    private void jButtonViewActionPerformed(ActionEvent evt) {
        DialogFilePreview dialog = new DialogFilePreview((JDialog)((Object)this), false, this.filePath);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        try {
            List<IGDScheme> schemes = this.db.getIGDSchemes(3);
            Collections.sort(schemes);
            List<IGDScheme> sqSchemes = this.db.getIGDSchemes(10);
            Collections.sort(sqSchemes);
            schemes.addAll(sqSchemes);
            DialogList<IGDScheme> dialog = new DialogList<IGDScheme>((JDialog)((Object)this), true, "Select Scheme", new UserPrefsHelper(this.db), schemes, true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.schID = dialog.getSelection().getID();
                this.jTextFieldScheme.setText(dialog.getSelection().toString());
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error loading schemes", sql, (Component)((Object)this));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtoaddagecurves.html");
    }
}

