/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import jsbugs.AnalystHeaderTableModel;
import jsbugs.DialogAnalystHeader;
import jsbugs.FrameJsbugs;
import jsbugs.abnsch.DialogAbnSchemes;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.AnalystHeader;
import model3.SBdb;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SbugsOptionToggle;
import util.exception.StackError;

public class DialogAnalystHeaders
extends JDialog {
    private final AnalystHeaderTableModel model;
    private TableRowSorter<AnalystHeaderTableModel> rowSorter;
    private final boolean toSelect;
    private final Well well;
    AnalystHeader selection = null;
    private JButton jButtonAbnSchemes;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JTable jTableAnalystHeader;
    private JToggleButton jToggleButton1;

    public DialogAnalystHeaders(Frame parent, boolean modal, SBdb db, Well well, boolean toSelect) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.model = new AnalystHeaderTableModel(db);
        this.rowSorter = new TableRowSorter<AnalystHeaderTableModel>(this.model);
        this.toSelect = toSelect;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Analysis Suites : " + this.well.getWellName());
        this.model.setupTable(this.jTableAnalystHeader);
        this.jTableAnalystHeader.setRowSorter(this.rowSorter);
        new ColumnSortResetHandler(this.jTableAnalystHeader).attach();
        this.model.hdrs = this.well.getAnalystHeaders();
        this.model.fireTableDataChanged();
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.rowSorter.setSortKeys(sortKeys);
        if (this.toSelect) {
            this.jButtonClose.setText("Cancel");
        } else {
            this.jButtonOK.setVisible(false);
        }
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonDelete.setEnabled(false);
        }
        ((SbugsOptionToggle)this.jToggleButton1).addComponents(this.toSelect, new JComponent[]{this.jButtonAdd, this.jButtonEdit, this.jButtonDelete, this.jSeparator2, this.jButtonAbnSchemes});
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableAnalystHeader = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonAbnSchemes = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jToggleButton1 = new SbugsOptionToggle();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 400));
        this.jTableAnalystHeader.setModel(this.model);
        this.jTableAnalystHeader.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogAnalystHeaders this$0;
            {
                DialogAnalystHeaders dialogAnalystHeaders = this$0;
                Objects.requireNonNull(dialogAnalystHeaders);
                this.this$0 = dialogAnalystHeaders;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableAnalystHeaderMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableAnalystHeader);
        this.jButtonClose.setText("Close");
        this.jButtonClose.setPreferredSize(new Dimension(97, 23));
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeaders this$0;
            {
                DialogAnalystHeaders dialogAnalystHeaders = this$0;
                Objects.requireNonNull(dialogAnalystHeaders);
                this.this$0 = dialogAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeaders this$0;
            {
                DialogAnalystHeaders dialogAnalystHeaders = this$0;
                Objects.requireNonNull(dialogAnalystHeaders);
                this.this$0 = dialogAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeaders this$0;
            {
                DialogAnalystHeaders dialogAnalystHeaders = this$0;
                Objects.requireNonNull(dialogAnalystHeaders);
                this.this$0 = dialogAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setPreferredSize(new Dimension(97, 23));
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeaders this$0;
            {
                DialogAnalystHeaders dialogAnalystHeaders = this$0;
                Objects.requireNonNull(dialogAnalystHeaders);
                this.this$0 = dialogAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jSeparator2.setPreferredSize(new Dimension(97, 2));
        this.jButtonAbnSchemes.setText("Abn.Schemes...");
        this.jButtonAbnSchemes.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAbnSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeaders this$0;
            {
                DialogAnalystHeaders dialogAnalystHeaders = this$0;
                Objects.requireNonNull(dialogAnalystHeaders);
                this.this$0 = dialogAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAbnSchemesActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setPreferredSize(new Dimension(97, 23));
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeaders this$0;
            {
                DialogAnalystHeaders dialogAnalystHeaders = this$0;
                Objects.requireNonNull(dialogAnalystHeaders);
                this.this$0 = dialogAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.setPreferredSize(new Dimension(97, 23));
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeaders this$0;
            {
                DialogAnalystHeaders dialogAnalystHeaders = this$0;
                Objects.requireNonNull(dialogAnalystHeaders);
                this.this$0 = dialogAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jToggleButton1.setText(">");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 632, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 116, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jToggleButton1, -2, 40, -2).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAbnSchemes, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator2, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonDelete, this.jButtonEdit}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToggleButton1).addPreferredGap(0).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator2, -2, 13, -2).addPreferredGap(0).add((Component)this.jButtonAbnSchemes).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonHelp, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonClose, -2, -1, -2)).add((Component)this.jScrollPane1, -1, 367, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogAnalystHeader dialog = new DialogAnalystHeader(this, true, this.model.db, this.well, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.hdrs = this.well.getAnalystHeaders();
                this.model.fireTableDataChanged();
                int index = this.jTableAnalystHeader.convertRowIndexToView(this.model.hdrs.indexOf(dialog.hdr));
                this.jTableAnalystHeader.setRowSelectionInterval(index, index);
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableAnalystHeader.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row only from table", this.getTitle(), 1);
            return;
        }
        AnalystHeader hdr = this.model.hdrs.get(this.jTableAnalystHeader.convertRowIndexToModel(this.jTableAnalystHeader.getSelectedRow()));
        try {
            DialogAnalystHeader dialog = new DialogAnalystHeader(this, true, this.model.db, this.well, hdr);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                int index = this.jTableAnalystHeader.convertRowIndexToView(this.model.hdrs.indexOf(dialog.hdr));
                this.jTableAnalystHeader.setRowSelectionInterval(index, index);
                this.model.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableAnalystHeader.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row only from table", this.getTitle(), 1);
            return;
        }
        AnalystHeader hdr = this.model.hdrs.get(this.jTableAnalystHeader.convertRowIndexToModel(this.jTableAnalystHeader.getSelectedRow()));
        try {
            String msg;
            int option;
            if (this.model.db.restrictedToDiscID(hdr.getDiscipline())) {
                JOptionPane.showMessageDialog(this, "You can only add/edit data within your own discipline. See Config Personnel from the Control panel");
                return;
            }
            int nAnalyses = this.well.getAnalysesOccs(hdr);
            if (nAnalyses > 0 && (option = JOptionPane.showConfirmDialog(this, msg = "There " + (nAnalyses == 1 ? "is " : "are ") + nAnalyses + " analy" + (nAnalyses == 1 ? "sis" : "ses") + " in this suite.\nDo you want to delete " + (nAnalyses == 1 ? "it?" : "them all?"), this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.well.deleteAnalyses(hdr);
            this.model.db.commit();
            this.model.hdrs = this.well.getAnalystHeaders();
            this.model.fireTableDataChanged();
        }
        catch (SBException sbe) {
            this.model.db.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            this.model.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jTableAnalystHeaderMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.toSelect) {
                this.jButtonOKActionPerformed(null);
            } else {
                this.jButtonEditActionPerformed(null);
            }
        }
    }

    private void jButtonAbnSchemesActionPerformed(ActionEvent evt) {
        try {
            DialogAbnSchemes dialog = new DialogAbnSchemes(this, this.model.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showDialogStackError(e, this);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableAnalystHeader.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one entry. Add a new analysis suite if list is empty", this.getTitle(), 1);
            return;
        }
        this.selection = this.model.hdrs.get(this.jTableAnalystHeader.convertRowIndexToModel(this.jTableAnalystHeader.getSelectedRow()));
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoganalystheaders.html");
    }
}

