/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.sbconnect.ConnectionParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Objects;
import java.util.prefs.BackingStoreException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.SbugsIO;

public class DialogBackup
extends JDialog {
    final ConnectionParameters parms;
    File location;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelect;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonDF1;
    private JRadioButton jRadioButtonDF2;
    private JRadioButton jRadioButtonDF3;
    private JRadioButton jRadioButtonNoZip;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDBFile;
    private JTextField jTextFieldLocation;

    public DialogBackup(Frame parent, boolean modal, ConnectionParameters parameters) {
        super(parent, modal);
        this.parms = parameters;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("StrataBugs Database Backup");
        this.jTextFieldDBFile.setText(this.parms.getHostName());
        this.jTextFieldLocation.setText(this.parms.getBackupLocation());
        switch (this.parms.getBackupCompressed()) {
            case 0: {
                this.jRadioButtonNoZip.setSelected(true);
                break;
            }
            case 3: {
                this.jRadioButtonDF3.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonDF1.setSelected(true);
                break;
            }
            case 2: {
                this.jRadioButtonDF2.setSelected(true);
            }
        }
        if (!this.parms.getBackupLocation().isEmpty()) {
            this.location = new File(this.parms.getBackupLocation());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jButtonSelect = new JButton();
        this.jTextFieldLocation = new JTextField();
        this.jTextFieldDBFile = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jRadioButtonDF1 = new JRadioButton();
        this.jRadioButtonDF2 = new JRadioButton();
        this.jRadioButtonDF3 = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.jRadioButtonNoZip = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBackup this$0;
            {
                DialogBackup dialogBackup = this$0;
                Objects.requireNonNull(dialogBackup);
                this.this$0 = dialogBackup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBackup this$0;
            {
                DialogBackup dialogBackup = this$0;
                Objects.requireNonNull(dialogBackup);
                this.this$0 = dialogBackup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setForeground(new Color(102, 0, 102));
        this.jButtonSelect.setText("...");
        this.jButtonSelect.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBackup this$0;
            {
                DialogBackup dialogBackup = this$0;
                Objects.requireNonNull(dialogBackup);
                this.this$0 = dialogBackup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectActionPerformed(evt);
            }
        });
        this.jTextFieldLocation.setEditable(false);
        this.jTextFieldDBFile.setEditable(false);
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Database file: ");
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Backup location:");
        this.buttonGroup1.add(this.jRadioButtonDF1);
        this.jRadioButtonDF1.setSelected(true);
        this.jRadioButtonDF1.setLabel("dd-MMM-YY_time");
        this.buttonGroup1.add(this.jRadioButtonDF2);
        this.jRadioButtonDF2.setText("YYYY-MM-dd_time");
        this.buttonGroup1.add(this.jRadioButtonDF3);
        this.jRadioButtonDF3.setLabel("YYYY-MMM-dd_time");
        this.jLabel3.setText("Compress into dated Zip file, format:");
        this.buttonGroup1.add(this.jRadioButtonNoZip);
        this.jRadioButtonNoZip.setText("Do not compress into ZIP file, just copy h2 file");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 76, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jRadioButtonDF1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonDF2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonDF3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonNoZip, -1, -1, Short.MAX_VALUE)).addComponent(this.jTextFieldDBFile, GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldLocation).addGap(18, 18, 18).addComponent(this.jButtonSelect))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDBFile, -2, -1, -2).addComponent(this.jLabel1)).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLocation, -2, -1, -2).addComponent(this.jButtonSelect).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonDF1).addComponent(this.jRadioButtonDF2).addComponent(this.jRadioButtonDF3).addComponent(this.jLabel3).addComponent(this.jRadioButtonNoZip)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel)).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.location == null || !this.location.exists()) {
            JOptionPane.showMessageDialog(this, "Location not set, or not writeable.");
            return;
        }
        File file = new File(this.parms.getHostName() + ".mv.db");
        if (!file.exists() && !(file = new File(this.parms.getHostName() + ".h2.db")).exists()) {
            JOptionPane.showMessageDialog(this, "Can't find database file: " + file.getAbsolutePath());
            return;
        }
        try {
            String dest;
            boolean paramsChanged = false;
            if (!this.location.getAbsolutePath().equalsIgnoreCase(this.parms.getBackupLocation())) {
                this.parms.setBackupLocation(this.location.getAbsolutePath());
                paramsChanged = true;
            }
            String dfString = null;
            int dfOpt = 0;
            if (!this.jRadioButtonNoZip.isSelected()) {
                if (this.jRadioButtonDF1.isSelected()) {
                    dfString = this.jRadioButtonDF1.getText();
                    dfOpt = 1;
                } else if (this.jRadioButtonDF2.isSelected()) {
                    dfString = this.jRadioButtonDF2.getText();
                    dfOpt = 2;
                } else {
                    dfString = this.jRadioButtonDF3.getText();
                    dfOpt = 3;
                }
                dfString = dfString.replace("_time", "_kkmm");
                paramsChanged = true;
            }
            if (this.parms.getBackupCompressed() != dfOpt) {
                this.parms.setBackupCompressed(dfOpt);
                paramsChanged = true;
            }
            if (paramsChanged) {
                this.parms.putPreferences(false);
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!this.jRadioButtonNoZip.isSelected()) {
                Calendar c = Calendar.getInstance();
                SimpleDateFormat df = new SimpleDateFormat(dfString);
                String fileName = file.getName().substring(0, file.getName().indexOf(46));
                File zipFile = new File(this.location.getAbsolutePath() + File.separator + "StrataBugs_backup_" + fileName + "_" + df.format(c.getTime()) + ".zip");
                ArrayList<File> list = new ArrayList<File>(1);
                list.add(file);
                dest = zipFile.getAbsolutePath();
                System.out.println("Compressing to: " + dest);
                SbugsIO.writeZipFile(zipFile, list);
            } else {
                int opt;
                File destDBfile = new File(this.location.getAbsolutePath() + File.separator + file.getName());
                if (destDBfile.exists() && (opt = JOptionPane.showConfirmDialog(this, "Overwrite?", this.getTitle(), 0, 3)) == 1) {
                    return;
                }
                dest = destDBfile.toPath().toString();
                System.out.println("Copying: " + String.valueOf(file.toPath()) + " to: " + dest);
                Files.copy(file.toPath(), destDBfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            JOptionPane.showMessageDialog(this, "Copy complete to: " + dest);
            this.dispose();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error copying file: " + ioe.getMessage());
        }
        catch (BackingStoreException ex) {
            JOptionPane.showMessageDialog(this, "Error saving parameters: " + ex.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.location = fc.getSelectedFile();
            this.jTextFieldLocation.setText(this.location.getPath());
        }
    }
}

