/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.user.User;
import com.stratadata.util.DateUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.TableRowSorter;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplateInfo;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.TemplateDescr;
import jsbchart.core.TemplateDescrImpl;
import jsbchart.core.process.BlockTemplateMerge;
import jsbugs.DialogList;
import jsbugs.TableModelBlockTemplates;
import jsbugs.chart.DialogBlockTemplateCompare;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.DialogSelectAnalyst;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.BasicMultiStageProcessHandler;
import jsbugs.wellheader.DialogSelectWell;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import model3.project.Project;
import model3.project.WellList;
import util.SBException;
import util.SBPermissionException;

public class DialogChartTemplates
extends JDialog {
    private static final int NAME_LEN = 150;
    private static Object lastType = null;
    private static Object lastProject = null;
    private static final String CHART_STRING = "Chart";
    private static final String ALL_STRING = "All types";
    public static final String PROJ_ALL = "All";
    public static final String PROJ_GLOBAL = "Global";
    private static int WINDOW_WIDTH;
    private static int WINDOW_HEIGHT;
    private final DefaultComboBoxModel typeModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel wellListModel = new DefaultComboBoxModel();
    private TableModelBlockTemplates model;
    private final ChartManager chartManager;
    private final SBdb sbdb;
    private final BlockType restrictToBlockType;
    private final Boolean charts;
    private final Well well;
    private static boolean showingMore;
    private Well advSearchWell;
    public List<ChartTemplateBase> selection;
    private Box.Filler filler1;
    private JButton jButtonAnalyst;
    private JButton jButtonClearWell;
    private JButton jButtonClose;
    private JButton jButtonCompare;
    private JButton jButtonDelete;
    private JButton jButtonMerge;
    private JButton jButtonOpen;
    private JButton jButtonSearch;
    private JButton jButtonWells;
    private JCheckBox jCheckBoxMultiWell;
    private JCheckBox jCheckBoxSingleWell;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxType;
    private JComboBox jComboBoxWellList;
    private JFormattedTextField jFormattedTextFieldDateFrom;
    private JFormattedTextField jFormattedTextFieldDateTo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelWells;
    private JPanel jPanelAdvanced;
    private JPanel jPanelSearch;
    private JScrollPane jScrollPane1;
    private JTable jTableBlocks;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldName;
    private JTextField jTextFieldWells;
    private JToggleButton jToggleButtonAdv;
    private JToggleButton jToggleButtonClear;

    public DialogChartTemplates(Frame parent, boolean modal, SBdb sbdb, ChartManager chartManager) {
        super(parent, modal);
        this.chartManager = chartManager;
        this.sbdb = sbdb;
        this.restrictToBlockType = null;
        this.charts = true;
        this.well = null;
        this.model = new TableModelBlockTemplates(sbdb);
        this.initComponents();
        this.init();
    }

    public DialogChartTemplates(Frame parent, boolean modal, SBdb sbdb, ChartManager chartManager, BlockType restrictBlockType, Boolean charts, Well well) {
        super(parent, modal);
        this.chartManager = chartManager;
        this.sbdb = sbdb;
        this.restrictToBlockType = restrictBlockType;
        this.charts = charts;
        this.well = well;
        this.model = new TableModelBlockTemplates(sbdb);
        this.initComponents();
        this.init();
    }

    public DialogChartTemplates(Dialog parent, boolean modal, SBdb sbdb, ChartManager chartManager, BlockType restrictBlockType, Boolean charts, Well well) {
        super(parent, modal);
        this.chartManager = chartManager;
        this.sbdb = sbdb;
        this.restrictToBlockType = restrictBlockType;
        this.charts = charts;
        this.well = well;
        this.model = new TableModelBlockTemplates(sbdb);
        this.initComponents();
        this.init();
    }

    public DialogChartTemplates(Frame parent, boolean modal, SBdb sbdb, ChartManager chartManager, List<ChartTemplateBase> templates) {
        super(parent, modal);
        this.chartManager = chartManager;
        this.sbdb = sbdb;
        this.restrictToBlockType = null;
        this.charts = true;
        this.well = null;
        this.model = new TableModelBlockTemplates(sbdb);
        this.initComponents();
        this.init();
        this.init(templates);
    }

    public DialogChartTemplates(Dialog parent, boolean modal, SBdb sbdb, ChartManager chartManager, List<ChartTemplateBase> templates) {
        super(parent, modal);
        this.chartManager = chartManager;
        this.sbdb = sbdb;
        this.restrictToBlockType = null;
        this.charts = true;
        this.well = null;
        this.model = new TableModelBlockTemplates(sbdb);
        this.initComponents();
        this.init();
        this.init(templates);
    }

    private void init() {
        if (this.jPanelSearch.isVisible()) {
            this.initTypeCombo();
            this.initProjectCombo();
        }
        this.model.setupTable(this.jTableBlocks, this.sbdb);
        this.jTableBlocks.setRowSorter(new TableRowSorter<TableModelBlockTemplates>(this.model));
        new ColumnSortResetHandler(this.jTableBlocks).attach();
        this.setTitle("Template Manager");
        this.getRootPane().setDefaultButton(this.jButtonOpen);
        if (this.restrictToBlockType == BlockType.SCHEME || this.restrictToBlockType == BlockType.WELL && this.charts == null) {
            this.jTableBlocks.setSelectionMode(0);
        } else {
            this.jTableBlocks.setSelectionMode(2);
        }
        this.jToggleButtonAdv.setSelected(showingMore);
        this.enableMore();
        TextFieldUtils.initSBDateFormatter(this.jFormattedTextFieldDateTo, null);
        TextFieldUtils.initSBDateFormatter(this.jFormattedTextFieldDateFrom, null);
        this.enableAdvCharts();
        String defaults = Lastval.tryGetString(this.sbdb, "TEMPLSRCH");
        if (defaults != null && !defaults.isEmpty()) {
            this.jTextFieldName.setText(defaults);
        }
        if (WINDOW_HEIGHT > 0 && WINDOW_WIDTH > 0) {
            this.setPreferredSize(new Dimension(WINDOW_WIDTH, WINDOW_HEIGHT));
            this.pack();
        }
    }

    private void init(List<ChartTemplateBase> templates) {
        this.model.setTemplates(new ArrayList<TemplateDescr>(templates.stream().map(chartTemplateBase -> chartTemplateBase).toList()));
        this.model.fireTableDataChanged();
        this.jPanelSearch.setVisible(false);
        this.jButtonMerge.setVisible(false);
    }

    private void initTypeCombo() {
        if (this.charts != null) {
            this.typeModel.addElement(CHART_STRING);
        }
        for (BlockType t : BlockType.values()) {
            if (this.restrictToBlockType != null && this.restrictToBlockType != t) continue;
            this.typeModel.addElement(t);
        }
        if (this.typeModel.getSize() > 1) {
            this.typeModel.insertElementAt(ALL_STRING, 0);
        }
        if (lastType != null) {
            this.jComboBoxType.setSelectedItem(lastType);
        } else {
            this.jComboBoxType.setSelectedIndex(0);
        }
    }

    private void initProjectCombo() {
        this.projectModel.addElement(PROJ_ALL);
        this.projectModel.addElement(PROJ_GLOBAL);
        try {
            if (this.well == null) {
                ProjectUtils.loadProjectCombo(this.sbdb, this.projectModel, false);
            } else {
                for (Integer i : this.well.getDataModel().getProjIDs(this.well)) {
                    this.projectModel.addElement(this.sbdb.getProject(i));
                }
                this.projectModel.removeElement(PROJ_ALL);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
        if (lastProject != null && this.projectModel.getIndexOf(lastProject) > -1) {
            this.jComboBoxProject.setSelectedItem(lastProject);
        }
    }

    private void refreshWellLists() {
        Object o = this.jComboBoxProject.getSelectedItem();
        this.wellListModel.removeAllElements();
        if (o instanceof Project) {
            Project project = (Project)((Object)o);
            this.jComboBoxWellList.setEnabled(true);
            this.wellListModel.addElement(PROJ_ALL);
            List wellLists = this.sbdb.getWellListService().getWellLists(project.getID());
            this.wellListModel.addAll(wellLists);
        } else {
            this.jComboBoxWellList.setEnabled(false);
        }
        this.jComboBoxWellList.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableBlocks = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonOpen = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanelSearch = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jTextFieldName = TextFieldUtils.buildLimitedLengthTextField(150);
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jToggleButtonAdv = new JToggleButton();
        this.jToggleButtonClear = new JToggleButton();
        this.jButtonSearch = new JButton();
        this.jPanelAdvanced = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldAnalyst = new JTextField();
        this.jButtonAnalyst = new JButton();
        this.jLabelWells = new JLabel();
        this.jTextFieldWells = new JTextField();
        this.jButtonWells = new JButton();
        this.jCheckBoxSingleWell = new JCheckBox();
        this.jCheckBoxMultiWell = new JCheckBox();
        this.jFormattedTextFieldDateFrom = new JFormattedTextField();
        this.jFormattedTextFieldDateTo = new JFormattedTextField();
        this.jButtonClearWell = new JButton();
        this.jComboBoxWellList = new JComboBox();
        this.jLabel8 = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jButtonMerge = new JButton();
        this.jButtonCompare = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(540, 450));
        this.jTableBlocks.setModel(this.model);
        this.jTableBlocks.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableBlocksMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableBlocks);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonOpen.setText("Open...");
        this.jButtonOpen.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete selected");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Type:");
        this.jComboBoxType.setModel(this.typeModel);
        this.jComboBoxType.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxType.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jTextFieldName.setText("%");
        this.jTextFieldName.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldNameFocusGained(evt);
            }
        });
        this.jLabel2.setText("Name:");
        this.jLabel3.setText("Project:");
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projectModel);
        this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxProject.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jComboBoxProjectItemStateChanged(evt);
            }
        });
        this.jLabel7.setHorizontalAlignment(11);
        this.jLabel7.setText("Well:");
        this.jToggleButtonAdv.setSelected(true);
        this.jToggleButtonAdv.setText("Show more options");
        this.jToggleButtonAdv.setFocusable(false);
        this.jToggleButtonAdv.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jToggleButtonAdvActionPerformed(evt);
            }
        });
        this.jToggleButtonClear.setText("Clear");
        this.jToggleButtonClear.setToolTipText("Clear search fields");
        this.jToggleButtonClear.setFocusable(false);
        this.jToggleButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jToggleButtonClearActionPerformed(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jPanelAdvanced.setBorder(BorderFactory.createTitledBorder(null, "Advanced Search", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel4.setText("Created or modified between");
        this.jLabel5.setText("and");
        this.jLabel6.setText("by:");
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonAnalyst.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalystActionPerformed(evt);
            }
        });
        this.jLabelWells.setText("Containing well:");
        this.jTextFieldWells.setEditable(false);
        this.jButtonWells.setText("...");
        this.jButtonWells.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonWells.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellsActionPerformed(evt);
            }
        });
        this.jCheckBoxSingleWell.setSelected(true);
        this.jCheckBoxSingleWell.setText("Single-well");
        this.jCheckBoxMultiWell.setSelected(true);
        this.jCheckBoxMultiWell.setText("Multi-well");
        this.jFormattedTextFieldDateFrom.setFormatterFactory(new DefaultFormatterFactory(new DateFormatter(new SimpleDateFormat("dd-MMM-yy"))));
        this.jFormattedTextFieldDateFrom.setToolTipText("");
        this.jFormattedTextFieldDateFrom.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jFormattedTextFieldDateFromFocusLost(evt);
            }
        });
        this.jFormattedTextFieldDateTo.setFormatterFactory(new DefaultFormatterFactory(new DateFormatter(new SimpleDateFormat("dd-MMM-yy"))));
        this.jButtonClearWell.setText("Clear");
        this.jButtonClearWell.setMargin(new Insets(2, 12, 2, 12));
        this.jButtonClearWell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearWellActionPerformed(evt);
            }
        });
        GroupLayout jPanelAdvancedLayout = new GroupLayout(this.jPanelAdvanced);
        this.jPanelAdvanced.setLayout(jPanelAdvancedLayout);
        jPanelAdvancedLayout.setHorizontalGroup(jPanelAdvancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAdvancedLayout.createSequentialGroup().addContainerGap().addGroup(jPanelAdvancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelAdvancedLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFormattedTextFieldDateFrom, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFormattedTextFieldDateTo, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAnalyst, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAnalyst, -2, 30, -2)).addGroup(jPanelAdvancedLayout.createSequentialGroup().addComponent(this.jLabelWells).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelAdvancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAdvancedLayout.createSequentialGroup().addComponent(this.jCheckBoxSingleWell).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxMultiWell)).addGroup(jPanelAdvancedLayout.createSequentialGroup().addComponent(this.jTextFieldWells).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWells, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearWell))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelAdvancedLayout.linkSize(0, this.jFormattedTextFieldDateFrom, this.jFormattedTextFieldDateTo);
        jPanelAdvancedLayout.setVerticalGroup(jPanelAdvancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAdvancedLayout.createSequentialGroup().addContainerGap(12, Short.MAX_VALUE).addGroup(jPanelAdvancedLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jFormattedTextFieldDateFrom, -2, -1, -2).addComponent(this.jFormattedTextFieldDateTo, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jTextFieldAnalyst, -2, -1, -2).addComponent(this.jButtonAnalyst)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelAdvancedLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelWells).addComponent(this.jTextFieldWells, -2, -1, -2).addComponent(this.jButtonWells).addComponent(this.jButtonClearWell)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelAdvancedLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxSingleWell).addComponent(this.jCheckBoxMultiWell))));
        this.jComboBoxWellList.setMaximumRowCount(30);
        this.jComboBoxWellList.setModel(this.wellListModel);
        this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel8.setText("Well List:");
        GroupLayout jPanelSearchLayout = new GroupLayout(this.jPanelSearch);
        this.jPanelSearch.setLayout(jPanelSearchLayout);
        jPanelSearchLayout.setHorizontalGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSearchLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSearchLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel7, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButtonAdv).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jToggleButtonClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch)).addGroup(jPanelSearchLayout.createSequentialGroup().addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSearchLayout.createSequentialGroup().addGap(7, 7, 7).addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING))).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldName).addComponent(this.jComboBoxProject, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxWellList, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxType, 0, -1, Short.MAX_VALUE))).addGroup(jPanelSearchLayout.createSequentialGroup().addComponent(this.jPanelAdvanced, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelSearchLayout.linkSize(0, this.jButtonSearch, this.jToggleButtonClear);
        jPanelSearchLayout.setVerticalGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSearchLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxType, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProject, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxWellList, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addGroup(jPanelSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jToggleButtonAdv).addComponent(this.jToggleButtonClear).addComponent(this.jButtonSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelAdvanced, -2, -1, -2)));
        this.jButtonMerge.setText("Merge...");
        this.jButtonMerge.setToolTipText("Merge the selected block templates");
        this.jButtonMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMergeActionPerformed(evt);
            }
        });
        this.jButtonCompare.setText("Compare...");
        this.jButtonCompare.setToolTipText("Compare selected block templates of the same type");
        this.jButtonCompare.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTemplates this$0;
            {
                DialogChartTemplates dialogChartTemplates = this$0;
                Objects.requireNonNull(dialogChartTemplates);
                this.this$0 = dialogChartTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCompareActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelSearch, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.filler1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMerge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCompare).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOpen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonOpen);
        layout.linkSize(0, this.jButtonCompare, this.jButtonMerge);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanelSearch, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 294, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonOpen).addComponent(this.jButtonDelete).addComponent(this.jButtonMerge).addComponent(this.jButtonCompare)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.saveDefaults();
        this.dispose();
    }

    private void jButtonOpenActionPerformed(ActionEvent evt) {
        if (this.jTableBlocks.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a template", this.getTitle(), 2);
            return;
        }
        this.selection = this.getSelection();
        lastType = this.jComboBoxType.getSelectedItem();
        lastProject = this.jComboBoxProject.getSelectedItem();
        this.saveDefaults();
        this.dispose();
    }

    private List<ChartTemplateBase> getSelection() {
        LinkedList<ChartTemplateBase> selected = new LinkedList<ChartTemplateBase>();
        int[] nArray = this.jTableBlocks.getSelectedRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            TemplateDescr templateDescr = this.model.getTemplates().get(this.jTableBlocks.convertRowIndexToModel(i2));
            if (templateDescr instanceof ChartTemplateBase) {
                ChartTemplateBase ctb = (ChartTemplateBase)templateDescr;
                selected.add(ctb);
                continue;
            }
            if (templateDescr instanceof BlockTemplateInfo) {
                BlockTemplateInfo info = (BlockTemplateInfo)templateDescr;
                selected.add(this.chartManager.getBlockTemplateFromInfo(info));
                continue;
            }
            if (templateDescr instanceof TemplateDescrImpl) {
                TemplateDescrImpl t = (TemplateDescrImpl)templateDescr;
                try {
                    selected.add(this.chartManager.getLoadChartTemplate(t.getId()));
                }
                catch (SQLException ex) {
                    SbugsExceptionHandler.showStackError("Error loading chart template '" + t.getName() + "'", ex);
                }
                continue;
            }
            throw new IllegalStateException();
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSearchActionPerformed(ActionEvent evt) {
        if (this.jFormattedTextFieldDateTo.getValue() != null && this.jFormattedTextFieldDateFrom.getValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a start date or clear the end date", this.getTitle(), 2);
            return;
        }
        Integer userID = null;
        if (!this.jTextFieldAnalyst.getText().isEmpty() && (userID = (Integer)this.sbdb.getUserService().findUserByAbr(this.jTextFieldAnalyst.getText().toUpperCase().trim()).map(User::getUserID).orElse(null)) == null) {
            JOptionPane.showMessageDialog(this, "Unrecognised analyst", this.getTitle(), 2);
            return;
        }
        Boolean multiWell = null;
        if (this.jToggleButtonAdv.isSelected() && this.jCheckBoxMultiWell.isSelected() ^ this.jCheckBoxSingleWell.isSelected()) {
            multiWell = this.jCheckBoxMultiWell.isSelected();
        }
        try {
            Object o = this.jComboBoxType.getSelectedItem();
            LinkedList<TemplateDescr> l = new LinkedList<TemplateDescr>();
            Object pItem = this.jComboBoxProject.getSelectedItem();
            Integer projID = null;
            if (pItem instanceof Project) {
                Project project = (Project)((Object)pItem);
                projID = project.getID();
            } else if (pItem == PROJ_GLOBAL) {
                projID = 0;
            }
            Object wlItem = this.jComboBoxWellList.getSelectedItem();
            Integer wellListID = null;
            if (wlItem instanceof WellList) {
                WellList wellList = (WellList)((Object)wlItem);
                wellListID = wellList.getID();
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (o instanceof BlockType || o == ALL_STRING) {
                l.addAll(this.chartManager.searchBlockInfo((BlockType)(this.restrictToBlockType != null ? this.restrictToBlockType : (o == ALL_STRING ? null : (BlockType)o)), this.jTextFieldName.getText(), projID, DateUtils.asLocalDate((Date)((Date)this.jFormattedTextFieldDateFrom.getValue())), DateUtils.asLocalDate((Date)((Date)this.jFormattedTextFieldDateTo.getValue())), userID));
            }
            if (o == CHART_STRING || o == ALL_STRING) {
                l.addAll(this.chartManager.searchChartHeaders(this.jTextFieldName.getText(), projID, wellListID, this.charts != null && this.charts == false, (Date)this.jFormattedTextFieldDateFrom.getValue(), (Date)this.jFormattedTextFieldDateTo.getValue(), userID, this.advSearchWell != null ? Integer.valueOf(this.advSearchWell.getWellID()) : null, multiWell));
            }
            Collections.sort(l);
            this.model.setTemplates(l);
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError("Error from search", e, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTextFieldNameFocusGained(FocusEvent evt) {
        this.jTextFieldName.setCaretPosition(0);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int rowCount = this.jTableBlocks.getSelectedRowCount();
        if (rowCount == 0) {
            return;
        }
        Object msg = "Really delete ";
        msg = rowCount == 1 ? (String)msg + "this " + this.getSelection().get(0).getTypeDescr() + "?" : (String)msg + "these " + rowCount + " charts/templates?";
        int opt = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0);
        if (opt != 0) {
            return;
        }
        List<ChartTemplateBase> toKill = this.getSelection();
        for (ChartTemplateBase template : toKill) {
            try {
                this.chartManager.deleteTemplate(template);
                this.model.removeTemplate(template);
                this.sbdb.commit();
            }
            catch (SBException | SBPermissionException sbe) {
                JOptionPane.showMessageDialog(this, sbe.getMessage(), this.getTitle(), 2);
            }
            catch (SQLException sql) {
                this.sbdb.doRollback();
                SbugsExceptionHandler.showStackError(sql, this);
            }
        }
        this.model.fireTableDataChanged();
    }

    private void jTableBlocksMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOpenActionPerformed(null);
        }
    }

    private void jToggleButtonAdvActionPerformed(ActionEvent evt) {
        this.enableMore();
    }

    private void jFormattedTextFieldDateFromFocusLost(FocusEvent evt) {
        if (this.jFormattedTextFieldDateFrom.getValue() != null && this.jFormattedTextFieldDateTo.getValue() == null) {
            this.jFormattedTextFieldDateTo.setValue(new Date());
        }
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst(this, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                this.jTextFieldAnalyst.setText(dialog.selectedUser.getAbr());
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        this.enableAdvCharts();
    }

    private void jButtonWellsActionPerformed(ActionEvent evt) {
        DialogSelectWell dialog = new DialogSelectWell(this, true, this.sbdb, false, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getSelection() != null) {
            this.advSearchWell = dialog.getSelection().get(0);
            this.jTextFieldWells.setText(this.advSearchWell.getWellName());
        }
    }

    private void jButtonClearWellActionPerformed(ActionEvent evt) {
        this.advSearchWell = null;
        this.jTextFieldWells.setText("");
    }

    private void jToggleButtonClearActionPerformed(ActionEvent evt) {
        this.jTextFieldName.setText("%");
        this.jTextFieldName.setCaretPosition(0);
        this.jComboBoxType.setSelectedItem(ALL_STRING);
        this.jComboBoxProject.setSelectedItem(PROJ_ALL);
    }

    private void jComboBoxProjectItemStateChanged(ItemEvent evt) {
        this.refreshWellLists();
    }

    private void jButtonMergeActionPerformed(ActionEvent evt) {
        int rowCount = this.jTableBlocks.getSelectedRowCount();
        if (rowCount == 0) {
            return;
        }
        String title = "Merge Block Templates";
        if (rowCount == 1) {
            JOptionPane.showMessageDialog(this, "Select two or more block templates of the same type to merge", "Merge Block Templates", 1);
            return;
        }
        List<ChartTemplateBase> candidates = this.getSelection();
        int projID = 0;
        BlockType type = null;
        LinkedList<BlockTemplateParent> mergeCandidates = new LinkedList<BlockTemplateParent>();
        for (ChartTemplateBase selection : candidates) {
            if (!(selection instanceof BlockTemplateParent)) {
                JOptionPane.showMessageDialog(this, "You can only merge bock templates", "Merge Block Templates", 1);
                return;
            }
            BlockTemplateParent blockTemplateParent = (BlockTemplateParent)selection;
            if (type == null) {
                type = blockTemplateParent.getType();
            } else if (type != blockTemplateParent.getType()) {
                JOptionPane.showMessageDialog(this, "Merge candidates must all have the same block type", "Merge Block Templates", 1);
                return;
            }
            if (projID == 0) {
                projID = blockTemplateParent.getProjID();
            } else if (blockTemplateParent.getProjID() != 0 && blockTemplateParent.getProjID() != projID) {
                JOptionPane.showMessageDialog(this, "Merge candidates must be from the same project or global", "Merge Block Templates", 1);
                return;
            }
            mergeCandidates.add(blockTemplateParent);
        }
        DialogList dialog = new DialogList(this, true, "Select Block Template To Keep", null, mergeCandidates, true, false, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getOptionalSelection().isEmpty()) {
            return;
        }
        BlockTemplateParent target = (BlockTemplateParent)dialog.getSelection();
        mergeCandidates.remove(target);
        BlockTemplateMerge process = new BlockTemplateMerge(this.chartManager, this.sbdb, target, mergeCandidates);
        BasicMultiStageProcessHandler handler = new BasicMultiStageProcessHandler(process, this, "Merge Block Templates");
        handler.runProcess();
        if (process.succeeded()) {
            this.model.removeAll(mergeCandidates);
            this.model.fireTableDataChanged();
        }
    }

    private void jButtonCompareActionPerformed(ActionEvent evt) {
        int rowCount = this.jTableBlocks.getSelectedRowCount();
        if (rowCount == 0) {
            return;
        }
        String title = "Compare Block Templates";
        if (rowCount == 1) {
            JOptionPane.showMessageDialog(this, "Select two or more block templates of the same type to compare", "Compare Block Templates", 1);
            return;
        }
        List<ChartTemplateBase> candidates = this.getSelection();
        BlockType type = null;
        LinkedList<BlockTemplateParent> compareCandidates = new LinkedList<BlockTemplateParent>();
        for (ChartTemplateBase selection : candidates) {
            if (!(selection instanceof BlockTemplateParent)) {
                JOptionPane.showMessageDialog(this, "You can only compare bock templates", "Compare Block Templates", 1);
                return;
            }
            BlockTemplateParent blockTemplateParent = (BlockTemplateParent)selection;
            if (type == null) {
                type = blockTemplateParent.getType();
            } else if (type != blockTemplateParent.getType()) {
                JOptionPane.showMessageDialog(this, "All blocks must have the same block type", "Compare Block Templates", 1);
                return;
            }
            compareCandidates.add(blockTemplateParent);
        }
        if (compareCandidates.size() > 10) {
            JOptionPane.showMessageDialog(this, "You cannot compare more than 10 blocks at once.", "Compare Block Templates", 1);
            return;
        }
        DialogBlockTemplateCompare dialog = new DialogBlockTemplateCompare((Dialog)this, true, this.chartManager, compareCandidates.toArray(new BlockTemplateParent[0]));
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void enableMore() {
        this.jPanelAdvanced.setVisible(this.jToggleButtonAdv.isSelected());
        this.pack();
        this.jToggleButtonAdv.setText(this.jToggleButtonAdv.isSelected() ? "Show fewer options" : "Show more options");
    }

    private void enableAdvCharts() {
        boolean b = !(this.jComboBoxType.getSelectedItem() instanceof BlockType);
        this.jTextFieldWells.setEnabled(b);
        this.jButtonWells.setEnabled(b);
        this.jLabelWells.setEnabled(b);
        this.jCheckBoxMultiWell.setEnabled(b);
        this.jCheckBoxSingleWell.setEnabled(b);
    }

    private void saveDefaults() {
        Dimension windowSize = this.getSize();
        WINDOW_WIDTH = windowSize.width;
        WINDOW_HEIGHT = windowSize.height;
        String lastval = this.jTextFieldName.getText().trim();
        try {
            Lastval.putString(this.sbdb, "TEMPLSRCH", lastval);
            this.model.putTableColumnWidths(this.sbdb, this.jTableBlocks);
            this.model.putTableColumnOrder(this.sbdb, this.jTableBlocks);
            this.sbdb.commit();
            showingMore = this.jToggleButtonAdv.isSelected();
        }
        catch (SQLException e) {
            System.out.println("Failed to save search defaults for templates dialog");
        }
    }

    static {
        showingMore = false;
    }
}

